# *************************************************************************
# This script is used to store weblogic admin user credentials
# Usage: storeCredentials.sh <admin_url> <user_name> <password>
# *************************************************************************

# Check if the arguments were passed as arguments 
if test $# -ne 3
then
   echo "" 
   echo "============================================================================="
   echo "Invalid arguments. <admin_url>, <user_name> and <password> are required"
   echo "Usage: $0 <admin_url> <user_name> <password>"
   echo "Example: storeCredentials.sh t3://vaaacappl.aac.va.gov:7001 weblogic weblogic"
   echo "============================================================================="
   echo ""
else
   # Set common environment variables such as WEBLOGIC_CLASSPATH
   . "${WL_HOME}/common/bin/commEnv.sh"

   echo "Storing credentials ..."
   ${JAVA_HOME}/bin/java -cp ${WEBLOGIC_CLASSPATH} weblogic.Admin -adminurl $1 -username $2 -password $3  STOREUSERCONFIG 2>&1
   echo "Done"
fi 
