#!/bin/sh
# ******************************************************************************
# This script is used to create directories needed for the ESR Batch jobs

# BATCH_JOB_HOME - The root directory for all the files that will be created/consumed by the ESR batch jobs.
#
# ******************************************************************************

BATCH_JOB_HOME=$1
if [ "$BATCH_JOB_HOME" = "" ]; then
  BATCH_JOB_HOME=/u02/batchProcess
fi

echo "Creating directories under ${BATCH_JOB_HOME} ...."

mkdir ${BATCH_JOB_HOME}
mkdir ${BATCH_JOB_HOME}/AACLetter ${BATCH_JOB_HOME}/AACLetter/Processed ${BATCH_JOB_HOME}/AACLetter/Returned ${BATCH_JOB_HOME}/AACLetter/ToProcess
mkdir ${BATCH_JOB_HOME}/dataSynchronization ${BATCH_JOB_HOME}/dataSynchronization/ESRtoHECLegacy ${BATCH_JOB_HOME}/dataSynchronization/ESRtoIVM ${BATCH_JOB_HOME}/dataSynchronization/HECLegacytoESR ${BATCH_JOB_HOME}/dataSynchronization/IVMtoESR
mkdir ${BATCH_JOB_HOME}/oppExtract
mkdir ${BATCH_JOB_HOME}/receiveSignatureInformationFile
mkdir ${BATCH_JOB_HOME}/registry
mkdir ${BATCH_JOB_HOME}/sendNCOAAddressFileVerification
mkdir ${BATCH_JOB_HOME}/ssnVerification ${BATCH_JOB_HOME}/ssnVerification/Processed ${BATCH_JOB_HOME}/ssnVerification/Returned ${BATCH_JOB_HOME}/ssnVerification/ToProcess
mkdir ${BATCH_JOB_HOME}/vssc

echo "Completed creating directories under ${BATCH_JOB_HOME}."

