/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util.builder.decorator;

import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.util.builder.Validator;
import gov.va.med.fw.util.builder.ValidatorException;
import gov.va.med.fw.util.builder.decorator.AbstractBuilderDecorator;

public class InputValidatedBuilder
extends AbstractBuilderDecorator {
    private static final long serialVersionUID = -8191057741035141705L;
    private Validator inputValidator;

    public static Builder decorate(Builder builder, Validator inputValidator) {
        return new InputValidatedBuilder(builder, inputValidator);
    }

    protected InputValidatedBuilder(Builder builder, Validator inputValidator) {
        super(builder);
        if (inputValidator == null) {
            throw new IllegalArgumentException("inputValidator cannot be null");
        }
        this.inputValidator = inputValidator;
    }

    @Override
    public Object build(Object input) throws BuilderException {
        try {
            if (input != null) {
                this.inputValidator.validate(input);
            }
            return super.getBuilder().build(input);
        }
        catch (ValidatorException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }
}

