/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util.builder;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.ReflectionException;
import gov.va.med.fw.util.Reflector;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractBuilder
extends AbstractComponent
implements Builder {
    private static final long serialVersionUID = -1370346746640850300L;

    protected AbstractBuilder() {
    }

    @Override
    public Object build(Object input) throws BuilderException {
        if (input == null) {
            throw new BuilderException("Invalid null input object");
        }
        if (input instanceof Object[]) {
            try {
                return this.invokeBuild((Object[])input);
            }
            catch (NoSuchMethodException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Could not invoke method from unpackaged object array types");
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw new BuilderException(cause.getMessage(), cause);
            }
            catch (Exception e) {
                throw new BuilderException("Failed to build a concrete object", e);
            }
        }
        try {
            return this.invokeBuild(new Object[]{input});
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw new BuilderException(cause.getMessage(), cause);
        }
        catch (Exception e) {
            throw new BuilderException("Failed to build a concrete object", e);
        }
    }

    public Object invokeBuild(Object[] inputs) throws InvocationTargetException, NoSuchMethodException, ReflectionException {
        Method method = Reflector.findMethod(this, "build", inputs);
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes != null && paramTypes.length == 1 && Object.class.equals(paramTypes[0])) {
            throw new NoSuchMethodException();
        }
        return Reflector.invoke(this, "build", inputs);
    }
}

