/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.InvalidArgumentException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringUtils
extends org.apache.commons.lang.StringUtils {
    private static final char AMPERSAND = '&';
    private static final char SEMICOLON = ';';
    public static final char ZERO = '0';
    private static final Map replacementMap = new HashMap();
    private static Pattern pattern;
    private static Matcher matcher;
    protected static transient Log logger;

    public static String replaceHtmlEntities(String pString) {
        int base;
        StringBuffer sb = new StringBuffer();
        int index = base = 0;
        while ((index = pString.indexOf(38, base)) >= base) {
            sb.append(pString.substring(base, index));
            int index2 = pString.indexOf(59, index);
            if (index2 != -1 && index2 - index < 8) {
                String token = pString.substring(index + 1, index2);
                String replacement = (String)replacementMap.get(token);
                if (replacement != null) {
                    sb.append(replacement);
                } else {
                    sb.append('&');
                    sb.append(token);
                    sb.append(';');
                }
                base = index2 + 1;
                continue;
            }
            sb.append('&');
            base = index + 1;
        }
        sb.append(pString.substring(base));
        return sb.toString();
    }

    public static boolean contains(String[] strings, String string) {
        if (strings == null) {
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!StringUtils.equals((String)strings[i], (String)string)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWith(String string, String[] strings) {
        if (string == null || strings == null) {
            return false;
        }
        for (int i = 0; i < strings.length; ++i) {
            if (!string.startsWith(strings[i])) continue;
            return true;
        }
        return false;
    }

    public static String stringFor(Collection pList, String pListName) {
        StringBuffer sb = new StringBuffer();
        if (pListName != null) {
            sb.append(pListName);
            sb.append("=");
        }
        if (pList != null) {
            sb.append("{");
            Iterator iter = pList.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if (value instanceof Map) {
                    sb.append(StringUtils.stringFor((Map)value, "map"));
                } else if (value instanceof Collection) {
                    sb.append(StringUtils.stringFor((Collection)value, "coll"));
                } else {
                    sb.append(value);
                }
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public static String stringFor(Map pMap, String pMapName) {
        StringBuffer sb = new StringBuffer();
        if (pMapName != null) {
            sb.append(pMapName);
            sb.append("=");
        }
        if (pMap != null) {
            sb.append("{");
            Set mapSet = pMap.entrySet();
            Iterator iter = mapSet.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                sb.append("(");
                sb.append(entry.getKey());
                sb.append("=");
                Object value = entry.getValue();
                if (value instanceof Map) {
                    sb.append(StringUtils.stringFor((Map)value, "map"));
                } else if (value instanceof Collection) {
                    sb.append(StringUtils.stringFor((Collection)value, "coll"));
                } else {
                    sb.append(value);
                }
                sb.append(")");
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append("}");
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public static String keepAlphaAndHyphen(String string) {
        StringBuffer cleanString = new StringBuffer();
        if (StringUtils.isNotEmpty((String)string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetter(string.charAt(i)) && string.charAt(i) != '-') continue;
                cleanString.append(string.charAt(i));
            }
        }
        return cleanString.toString();
    }

    public static int compareTo(String string1, String string2) {
        if (string1 == null) {
            string1 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string1.compareTo(string2);
    }

    public static boolean isSameCharString(String string) {
        if (string != null) {
            for (int i = 1; i < string.length(); ++i) {
                if (string.charAt(i - 1) == string.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int numTimesStringPresent(String stringToCompare, String matchString) {
        if (StringUtils.isEmpty((String)stringToCompare) || StringUtils.isEmpty((String)matchString)) {
            return 0;
        }
        int count = 0;
        StringBuffer compareBuffer = new StringBuffer(stringToCompare);
        while (compareBuffer.length() > 0) {
            int index = compareBuffer.indexOf(matchString);
            if (index == -1) {
                compareBuffer.setLength(0);
                continue;
            }
            ++count;
            compareBuffer.delete(index, index + matchString.length());
        }
        return count;
    }

    public static String leftPadWithZero(String value, int desiredLength) throws InvalidArgumentException {
        String paddedValue = null;
        String strippedValue = StringUtils.stripToNull((String)value);
        if (StringUtils.isEmpty((String)strippedValue)) {
            if (logger.isErrorEnabled()) {
                logger.debug((Object)("Invalid argument to left pad with zeros: " + value));
            }
            throw new InvalidArgumentException("Invalid argument to left pad with zeros: ", null);
        }
        paddedValue = StringUtils.leftPad((String)strippedValue, (int)desiredLength, (char)'0');
        return paddedValue;
    }

    public static String truncToMaxLength(String value, int desiredLength) {
        if (!StringUtils.isEmpty((String)value) && value.length() > desiredLength) {
            return value.substring(0, desiredLength);
        }
        return value;
    }

    public static boolean containsNumbers(String str) {
        if (str == null || StringUtils.isEmpty((String)str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean validateEntry(String name, String name_pattern) {
        pattern = Pattern.compile(name_pattern);
        matcher = pattern.matcher(name);
        return matcher.matches();
    }

    static {
        logger = LogFactory.getLog((String)StringUtils.class.getName());
        replacementMap.put("amp", "&");
        replacementMap.put("gt", ">");
        replacementMap.put("lt", "<");
        replacementMap.put("quot", "\"");
        replacementMap.put("#39", "\\");
    }
}

