/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.util.ReflectionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Reflector {
    public static final int INTROSPECT_GET = 0;
    public static final int INTROSPECT_SET = 1;
    private static final Class[] noParams = new Class[0];

    protected Reflector() {
    }

    public static Object invoke(Object target, String methodName, Object[] params) throws InvocationTargetException, NoSuchMethodException, ReflectionException {
        try {
            Method m = Reflector.findMethod(target.getClass(), methodName, Reflector.typesOf(params));
            return m.invoke(target, params);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public static Method findMethod(Class targetClass, String methodName, Class[] types) throws NoSuchMethodException {
        NoSuchMethodException notFound = null;
        try {
            return targetClass.getMethod(methodName, types);
        }
        catch (NoSuchMethodException e) {
            notFound = e;
            Method[] methods = targetClass.getDeclaredMethods();
            Method match = Reflector.findMostExactMethod(methods, methodName, types);
            if (match == null && (match = Reflector.findMostExactMethod(methods = targetClass.getMethods(), methodName, types)) == null) {
                NoSuchMethodException temp = new NoSuchMethodException("Either none or more than one match for " + methodName + " and could not determine best fit");
                temp.initCause(notFound);
                throw temp;
            }
            return match;
        }
    }

    private static Method findMostExactMethod(Method[] methods, String methodName, Class[] types) {
        Method match = null;
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!Reflector.check(methods[i], methodName, types)) continue;
            matchingMethods.add(methods[i]);
        }
        if (matchingMethods.size() == 1) {
            match = (Method)matchingMethods.iterator().next();
        } else if (matchingMethods.size() > 1) {
            match = Reflector.findMostExactMethod(matchingMethods, types);
        }
        return match;
    }

    private static Method findMostExactMethod(List matchingMethods, Class[] types) {
        Class[] interfaces = types[0].getInterfaces();
        Method best = Reflector.searchMethodsBasedOnInterfaces(matchingMethods, interfaces, types.length);
        if (best != null) {
            return best;
        }
        for (Class superClass = types[0].getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            best = Reflector.searchMethodsBasedOnClass(matchingMethods, superClass, types.length);
            if (best != null) {
                return best;
            }
            best = Reflector.searchMethodsBasedOnInterfaces(matchingMethods, superClass.getInterfaces(), types.length);
            if (best == null) continue;
            return best;
        }
        return null;
    }

    private static Method searchMethodsBasedOnInterfaces(List matchingMethods, Class[] interfaces, int argSize) {
        int i;
        Method best = null;
        Class interfaceSuperClass = null;
        for (i = 0; interfaces != null && i < interfaces.length; ++i) {
            best = Reflector.searchMethodsBasedOnClass(matchingMethods, interfaces[i], argSize);
            if (best == null) continue;
            return best;
        }
        for (i = 0; interfaces != null && i < interfaces.length; ++i) {
            for (interfaceSuperClass = interfaces[i].getSuperclass(); interfaceSuperClass != null; interfaceSuperClass = interfaceSuperClass.getSuperclass()) {
                best = Reflector.searchMethodsBasedOnClass(matchingMethods, interfaceSuperClass, argSize);
                if (best == null) continue;
                return best;
            }
        }
        return null;
    }

    private static Method searchMethodsBasedOnClass(List matchingMethods, Class targetClazz, int argSize) {
        Class[] attempt = new Class[argSize];
        for (int i = 0; i < attempt.length; ++i) {
            attempt[i] = targetClazz;
        }
        Iterator itr = matchingMethods.iterator();
        Method candidate = null;
        while (itr.hasNext()) {
            candidate = (Method)itr.next();
            if (!Reflector.exactMatchClasses(candidate.getParameterTypes(), attempt)) continue;
            return candidate;
        }
        return null;
    }

    private static boolean exactMatchClasses(Class[] params1, Class[] params2) {
        if (params1.length != params2.length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            if (params1[i].getName().equals(params2[i].getName())) continue;
            return false;
        }
        return true;
    }

    public static Method findMethod(Object target, String methodName, Object[] params) throws NoSuchMethodException {
        return Reflector.findMethod(target.getClass(), methodName, Reflector.typesOf(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recursiveInvoke(Class ofType, Object target, String methodName, Object[] params, boolean shouldRecurseCollections, boolean shouldInvokeMethodOnTarget) throws ReflectionException {
        try {
            Class<?> klass = null;
            Field fld = null;
            Iterator itr = null;
            ArrayList<Object> matchingFields = new ArrayList<Object>();
            boolean usedIntrospection = false;
            if (shouldInvokeMethodOnTarget && ofType.isAssignableFrom(target.getClass())) {
                try {
                    Reflector.invoke(target, methodName, params);
                }
                catch (ReflectionException re) {
                    // empty catch block
                }
            }
            Field[] fields = target.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                matchingFields.clear();
                usedIntrospection = false;
                fld = fields[i];
                klass = fld.getType();
                if (ofType.isAssignableFrom(klass)) {
                    Object obj2 = null;
                    try {
                        obj2 = fld.get(target);
                        matchingFields.add(obj2);
                        Reflector.invoke(obj2, methodName, params);
                    }
                    catch (Throwable e) {
                        usedIntrospection = true;
                        matchingFields.addAll(Reflector.introspect(fld.getType(), target, null, 0));
                    }
                    finally {
                        if (matchingFields.size() >= 1) {
                            for (Object obj2 : matchingFields) {
                                if (obj2 == null) continue;
                                Reflector.recursiveInvoke(ofType, obj2, methodName, params, shouldRecurseCollections, usedIntrospection);
                            }
                        }
                    }
                }
                if (!shouldRecurseCollections || !Collection.class.isAssignableFrom(fld.getType())) continue;
                Reflector.recursiveInvokeCollection(ofType, target, methodName, params, fld);
            }
        }
        catch (Throwable e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    protected static void recursiveInvokeCollection(Class pOfType, Object pTarget, String pMethodName, Object[] pParams, Field pField) throws ReflectionException {
        if (pOfType == null || pTarget == null || pField == null || pMethodName == null) {
            throw new ReflectionException("Reflector.recursiveInvokeCollection contained null argument");
        }
        if (pField != null && Collection.class.isAssignableFrom(pField.getType())) {
            try {
                Collection coll = (Collection)pField.get(pTarget);
                Iterator itr = coll != null ? coll.iterator() : null;
                Object obj = null;
                while (itr != null && itr.hasNext()) {
                    obj = itr.next();
                    Reflector.recursiveInvoke(pOfType, obj, pMethodName, pParams, false, true);
                }
            }
            catch (Throwable t) {
                throw new ReflectionException(t.getMessage(), t);
            }
        }
    }

    public static List introspect(Class type, Object target, Object[] params, int operation) throws IntrospectionException, ReflectionException {
        Method method2 = null;
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Object> beanProps = new ArrayList<Object>();
        BeanInfo info = Introspector.getBeanInfo(target.getClass());
        PropertyDescriptor[] desc = info.getPropertyDescriptors();
        for (int i = 0; i < desc.length; ++i) {
            if (desc[i].getPropertyType() == null || !desc[i].getPropertyType().equals(type)) continue;
            if (operation == 0) {
                method2 = desc[i].getReadMethod();
            } else if (operation == 1) {
                method2 = desc[i].getWriteMethod();
            }
            methods.add(method2);
        }
        try {
            if (methods.size() >= 1) {
                for (Method method2 : methods) {
                    beanProps.add(Reflector.invoke(target, method2.getName(), params));
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
        return beanProps;
    }

    public static Class[] typesOf(Object[] params) {
        if (params == null) {
            return noParams;
        }
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i] == null ? Object.class : params[i].getClass();
        }
        return types;
    }

    protected static boolean checkParams(Class[] targetTypes, Class[] givenTypes) {
        boolean matched = true;
        if (targetTypes.length == givenTypes.length) {
            for (int i = 0; matched && i < targetTypes.length; ++i) {
                if (targetTypes[i] == Object.class || targetTypes[i].isAssignableFrom(givenTypes[i]) || givenTypes[i] == Integer.class && targetTypes[i] == Integer.TYPE || givenTypes[i] == Long.class && targetTypes[i] == Long.TYPE || givenTypes[i] == Byte.class && targetTypes[i] == Byte.TYPE || givenTypes[i] == Short.class && targetTypes[i] == Short.TYPE || givenTypes[i] == Float.class && targetTypes[i] == Float.TYPE || givenTypes[i] == Double.class && targetTypes[i] == Double.TYPE || givenTypes[i] == Boolean.class && targetTypes[i] == Boolean.TYPE) continue;
                matched = false;
                break;
            }
        } else {
            matched = false;
        }
        return matched;
    }

    protected static boolean check(Method m, String methodName, Class[] types) {
        return m.getName().equals(methodName) ? Reflector.checkParams(m.getParameterTypes(), types) : false;
    }

    public static Object instantiate(Class targetClass, Object[] params) throws ReflectionException {
        try {
            Constructor m = Reflector.findConstructor(targetClass, Reflector.typesOf(params));
            return m.newInstance(params);
        }
        catch (Exception e) {
            throw new ReflectionException(e.getMessage(), e);
        }
    }

    public static Object instantiate(String class_name) throws ReflectionException {
        return Reflector.instantiate(class_name, (Object[])noParams);
    }

    public static Object instantiate(String class_name, Object[] params) throws ReflectionException {
        Object instance = null;
        try {
            Class<?> aClass = Class.forName(class_name);
            instance = Reflector.instantiate(aClass, params);
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionException(e.getMessage(), e);
        }
        return instance;
    }

    public static Constructor findConstructor(Class targetClass, Class[] types) throws NoSuchMethodException {
        NoSuchMethodException notFound = null;
        try {
            return targetClass.getConstructor(types);
        }
        catch (NoSuchMethodException e) {
            notFound = e;
            Constructor<?>[] methods = targetClass.getConstructors();
            for (int i = 0; i < methods.length; ++i) {
                if (!Reflector.checkParams(methods[i].getParameterTypes(), types)) continue;
                return methods[i];
            }
            throw notFound;
        }
    }
}

