/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.util.PropertyInfo;
import gov.va.med.fw.util.SystemUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;

public class PrepareDomainCreationScript {
    private Map propertyInfoMap;
    private String unixTemplate;
    private String windowsTemplate;
    private String unixOutputFilename;
    private String windowsOutputFilename;
    private String environment;
    public static final String TEMPLATE_EXT = "_Template";
    public static final String UNIX_SCRIPT_EXT = ".sh";
    public static final String WINDOWS_SCRIPT_EXT = ".cmd";
    public static final String WINDOWS_OUTPUT_FIRST_PREFIX = ">  %SOUT% ECHO";
    public static final String WINDOWS_OUTPUT_PREFIX = ">> %SOUT% ECHO";
    public static final String TAG_DELIMITER = "@";
    public static final String BASE_ITEM_KEY = "0";
    public static final String ENABLED = "Enabled";
    public static final String NAME = "Name";
    public static final String LOOKUP = "Lookup";
    public static final String CREATE = "create";
    public static final String FIND = "find";
    public static final String ASSIGN = "Assign";
    public static final String KEY_SERVER = "Server";
    public static final String KEY_ADMIN_SERVER = "AdminServer";
    public static final String KEY_CLUSTER = "Cluster";
    public static final String KEY_MACHINE = "Machine";
    public static final String KEY_FILE_REALM = "FileRealm";
    public static final String KEY_REALM = "Realm";
    public static final String KEY_PASSWORD_POLICY = "PasswordPolicy";
    public static final String KEY_SECURITY_CONFIGURATION = "SecurityConfiguration";
    public static final String KEY_SECURITY = "Security";
    public static final String KEY_EMBEDDED_LDAP = "EmbeddedLDAP";
    public static final String KEY_JMS_CONNECTION_FACTORY = "JMSConnectionFactory";
    public static final String KEY_JMS_DISTRIBUTED_QUEUE = "JMSDistributedQueue";
    public static final String KEY_JMS_SERVER = "JMSServer";
    public static final String KEY_JMS_TEMPLATE = "JMSTemplate";
    public static final String KEY_JDBC_CONNECTION_POOL = "JDBCConnectionPool";
    public static final String KEY_JTA = "JTA";
    public static final String KEY_JDBC_TX_DATA_SOURCE = "JDBCTxDataSource";
    public static final String KEY_JMS_JDBC_STORE = "JMSJDBCStore";
    public static final String DOMAIN_CREATION_SCRIPT_TAG = "@domainCreationScript@";
    public static final String REDIRECT_ESCAPE = "@redirectEscape@";
    public static final String TEMPLATE_HOME = "TEMPLATE_HOME";
    public static final String TEMPLATE_FILENAME = "TEMPLATE_FILENAME";
    public static final String BEA_HOME = "BEA_HOME";
    public static final String FILE_SEPARATOR = "FILE_SEPARATOR";
    public static final String WINDOWS_FILE_SEPARATOR = "\\";
    public static final String UNIX_FILE_SEPARATOR = "/";
    public static final String CR = SystemUtils.LINE_SEPARATOR;
    public static final String HEADER_COMMENT = "/////////////////////////////////////////////////////////////////////////////////////////" + CR + "// This is the ESR Weblogic domain silent install script." + CR + "// This script was autogenerated by the ESR PrepareDomainCreationScript tool" + CR + "// and should not be modified." + CR + "//" + CR + "// Usage:" + CR + "//      @redirectEscape@<Windows@redirectEscape@> = config.cmd -mode=silent -silent_script=@redirectEscape@<silent script@redirectEscape@>" + CR + "//      @redirectEscape@<Unix@redirectEscape@>    = ./config.sh -mode=silent -silent_script=@redirectEscape@<silent script@redirectEscape@>" + CR + "//" + CR + "// Where:" + CR + "//      @redirectEscape@<silent script@redirectEscape@> should be the full path to the silent script." + CR + "/////////////////////////////////////////////////////////////////////////////////////////";
    public static final String ENVIRONMENT_COMMENT = "// This script will create a domain for the following environment: ";
    public static final String READ_IN_DOMAIN_TEMPLATE = "/////////////////////////////////////////////////////////////////////////////////////////" + CR + "// Read in a domain template." + CR + "/////////////////////////////////////////////////////////////////////////////////////////" + CR + "read template from \"@TEMPLATE_HOME@@FILE_SEPARATOR@@TEMPLATE_FILENAME@\";";
    public static final String WRITE_OUT_DOMAIN = "/////////////////////////////////////////////////////////////////////////////////////////" + CR + "// Write out the domain." + CR + "/////////////////////////////////////////////////////////////////////////////////////////" + CR + "set OverwriteDomain \"true\";" + CR + "write domain to \"@BEA_HOME@@FILE_SEPARATOR@user_projects@FILE_SEPARATOR@domains@FILE_SEPARATOR@EdbDevDomain2\";";
    public static final String CLOSE_TEMPLATE = "/////////////////////////////////////////////////////////////////////////////////////////" + CR + "// Close domain template to indicate completion of work." + CR + "/////////////////////////////////////////////////////////////////////////////////////////" + CR + "close template;";

    public PrepareDomainCreationScript(String env, String setupDir, String propsFilenameSuffix, String scriptFilenamePrefix) throws Exception {
        this.init(env, setupDir, propsFilenameSuffix, scriptFilenamePrefix);
    }

    protected void init(String env, String setupDir, String propsFilenameSuffix, String scriptFilenamePrefix) throws Exception {
        Validate.notNull((Object)env, (String)"Environment must be specified.");
        Validate.notNull((Object)setupDir, (String)"Setup directory must be specified.");
        Validate.notNull((Object)propsFilenameSuffix, (String)"Properties filename suffix must be specified.");
        Validate.notNull((Object)scriptFilenamePrefix, (String)"Script filename prefix must be specified.");
        this.setUnixOutputFilename(setupDir + File.separator + scriptFilenamePrefix + UNIX_SCRIPT_EXT);
        this.setWindowsOutputFilename(setupDir + File.separator + scriptFilenamePrefix + WINDOWS_SCRIPT_EXT);
        this.setEnvironment(env);
        String propsFilename = setupDir + File.separator + env + "." + propsFilenameSuffix;
        LinkedHashMap propertyMap = this.loadProperties(propsFilename);
        this.setPropertyInfoMap(this.processProperties(propertyMap));
        String unixTemplateFilename = setupDir + File.separator + scriptFilenamePrefix + TEMPLATE_EXT + UNIX_SCRIPT_EXT;
        String windowsTemplateFilename = setupDir + File.separator + scriptFilenamePrefix + TEMPLATE_EXT + WINDOWS_SCRIPT_EXT;
        this.setUnixTemplate(FileUtils.readFileToString((File)new File(unixTemplateFilename), null));
        this.setWindowsTemplate(FileUtils.readFileToString((File)new File(windowsTemplateFilename), null));
    }

    protected LinkedHashMap loadProperties(String propsFilename) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        BufferedReader reader = new BufferedReader(new FileReader(propsFilename));
        String line = reader.readLine();
        while (line != null) {
            if (StringUtils.isNotBlank((String)(line = line.trim())) && line.charAt(0) != '#') {
                int index = line.indexOf(61);
                if (index < 1 || index >= line.length() - 1) {
                    throw new RuntimeException("Invalid property line found: " + line);
                }
                map.put(line.substring(0, index), line.substring(index + 1, line.length()));
            }
            line = reader.readLine();
        }
        return map;
    }

    protected Map processProperties(LinkedHashMap inputPropertyMap) {
        LinkedHashMap<String, List> propInfoMap = new LinkedHashMap<String, List>();
        LinkedHashMap<String, LinkedHashMap<String, String>> keyMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        Iterator iterator = inputPropertyMap.keySet().iterator();
        while (iterator.hasNext()) {
            String propertyName;
            String propertyKey = propertyName = (String)iterator.next();
            String propertyValue = (String)inputPropertyMap.get(propertyName);
            int index = propertyName.indexOf(".");
            if (index <= 0 || index >= propertyName.length() - 1) {
                throw new RuntimeException("Illegal property found: '" + propertyName + "'.  Properties must be in the form of A.B, A.B.C, A.#.B or A.#.B.C.");
            }
            propertyKey = propertyName.substring(0, index);
            LinkedHashMap<String, String> subMap = (LinkedHashMap<String, String>)keyMap.get(propertyKey);
            if (subMap == null) {
                subMap = new LinkedHashMap<String, String>();
                keyMap.put(propertyKey, subMap);
            }
            subMap.put(propertyName, propertyValue);
        }
        for (String key : keyMap.keySet()) {
            propInfoMap.put(key, this.getPropertyInfoList(key, (Map)keyMap.get(key)));
        }
        return propInfoMap;
    }

    protected List getPropertyInfoList(String componentKey, Map propertyMap) {
        LinkedHashMap<String, PropertyInfo> indexMap = new LinkedHashMap<String, PropertyInfo>();
        boolean multiComponent = false;
        for (String propertyKey : propertyMap.keySet()) {
            PropertyInfo info;
            String propertyValue = (String)propertyMap.get(propertyKey);
            String[] tokens = propertyKey.split("\\.");
            int index = 1;
            String itemIndex = BASE_ITEM_KEY;
            if (NumberUtils.isDigits((String)tokens[index])) {
                multiComponent = true;
                itemIndex = tokens[index];
                ++index;
                if (itemIndex.equals(BASE_ITEM_KEY)) {
                    throw new RuntimeException("0 is not a valid property index.  Valid values must start at 1.");
                }
            }
            String childKey = null;
            String attribute = tokens[index];
            if (++index < tokens.length) {
                childKey = attribute;
                attribute = tokens[index];
            }
            if ((info = (PropertyInfo)indexMap.get(itemIndex)) == null) {
                info = new PropertyInfo();
                indexMap.put(itemIndex, info);
            }
            if (childKey == null) {
                LinkedHashMap attrMap = info.getAttributeMap();
                attrMap.put(attribute, propertyValue);
                continue;
            }
            LinkedHashMap childMap = info.getChildMap();
            PropertyInfo childInfo = (PropertyInfo)childMap.get(childKey);
            if (childInfo == null) {
                childInfo = new PropertyInfo();
                childMap.put(childKey, childInfo);
            }
            if (attribute.equals(ENABLED)) continue;
            LinkedHashMap childAttrMap = childInfo.getAttributeMap();
            childAttrMap.put(attribute, propertyValue);
        }
        ArrayList infoList = new ArrayList();
        if (multiComponent) {
            PropertyInfo baseInfo = (PropertyInfo)indexMap.get(BASE_ITEM_KEY);
            if (baseInfo != null) {
                LinkedHashMap baseAttributeMap = baseInfo.getAttributeMap();
                for (String baseAttribute : baseAttributeMap.keySet()) {
                    String baseValue = (String)baseAttributeMap.get(baseAttribute);
                    for (String index : indexMap.keySet()) {
                        PropertyInfo indexInfo;
                        LinkedHashMap attributeMap;
                        String indexAttribute;
                        if (index.equals(BASE_ITEM_KEY) || (indexAttribute = (String)(attributeMap = (indexInfo = (PropertyInfo)indexMap.get(index)).getAttributeMap()).get(baseAttribute)) != null) continue;
                        attributeMap.put(baseAttribute, baseValue);
                    }
                }
                LinkedHashMap baseChildMap = baseInfo.getChildMap();
                for (String baseChildKey : baseChildMap.keySet()) {
                    PropertyInfo baseChildInfo = (PropertyInfo)baseChildMap.get(baseChildKey);
                    for (String index : indexMap.keySet()) {
                        if (index.equals(BASE_ITEM_KEY)) continue;
                        PropertyInfo indexInfo = (PropertyInfo)indexMap.get(index);
                        LinkedHashMap childMap = indexInfo.getChildMap();
                        PropertyInfo indexChildInfo = (PropertyInfo)childMap.get(baseChildKey);
                        if (indexChildInfo == null) {
                            indexChildInfo = new PropertyInfo();
                            childMap.put(baseChildKey, indexChildInfo);
                        }
                        LinkedHashMap baseChildAttributeMap = baseChildInfo.getAttributeMap();
                        for (String baseChildAttribute : baseChildAttributeMap.keySet()) {
                            LinkedHashMap indexChildAttributeMap;
                            String indexChildAttribute;
                            String baseChildValue = (String)baseChildAttributeMap.get(baseChildAttribute);
                            if (baseChildAttribute.equals(ENABLED) || (indexChildAttribute = (String)(indexChildAttributeMap = indexChildInfo.getAttributeMap()).get(baseChildAttribute)) != null) continue;
                            indexChildAttributeMap.put(baseChildAttribute, baseChildValue);
                        }
                    }
                }
            }
            for (String index : indexMap.keySet()) {
                if (index.equals(BASE_ITEM_KEY)) continue;
                infoList.add(indexMap.get(index));
            }
        } else {
            infoList.add(indexMap.get(BASE_ITEM_KEY));
        }
        return infoList;
    }

    public void create() throws Exception {
        String domainCreationScript = this.getDomainCreationScript();
        String unixScript = this.replaceAll(this.getUnixTemplate(), DOMAIN_CREATION_SCRIPT_TAG, this.getUnixDomainCreationScript(domainCreationScript));
        String windowsScript = this.replaceAll(this.getWindowsTemplate(), DOMAIN_CREATION_SCRIPT_TAG, this.getWindowsDomainCreationScript(domainCreationScript));
        FileUtils.writeStringToFile((File)new File(this.getUnixOutputFilename()), (String)unixScript, null);
        FileUtils.writeStringToFile((File)new File(this.getWindowsOutputFilename()), (String)windowsScript, null);
    }

    protected String getWindowsDomainCreationScript(String domainCreationScript) {
        domainCreationScript = this.updateScriptVariables(domainCreationScript, true);
        StringBuffer buffer = new StringBuffer();
        String[] lines = domainCreationScript.split(CR);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i == 0) {
                buffer.append(WINDOWS_OUTPUT_FIRST_PREFIX);
            } else {
                buffer.append(CR);
                buffer.append(WINDOWS_OUTPUT_PREFIX);
            }
            if (StringUtils.isEmpty((String)line)) {
                buffer.append(".");
            } else {
                buffer.append(" ");
            }
            buffer.append(line);
        }
        return buffer.toString();
    }

    protected String getUnixDomainCreationScript(String domainCreationScript) {
        domainCreationScript = this.updateScriptVariables(domainCreationScript, false);
        return domainCreationScript;
    }

    protected String updateScriptVariables(String script, boolean windows) {
        String prefix = "${";
        String suffix = "}";
        String redirectEscape = "";
        String fileSeparator = UNIX_FILE_SEPARATOR;
        if (windows) {
            prefix = "%";
            suffix = "%";
            fileSeparator = WINDOWS_FILE_SEPARATOR;
            redirectEscape = "^";
        }
        script = this.replaceAll(script, "@TEMPLATE_HOME@", prefix + TEMPLATE_HOME + suffix);
        script = this.replaceAll(script, "@TEMPLATE_FILENAME@", prefix + TEMPLATE_FILENAME + suffix);
        script = this.replaceAll(script, "@BEA_HOME@", prefix + BEA_HOME + suffix);
        script = this.replaceAll(script, "@FILE_SEPARATOR@", fileSeparator);
        script = this.replaceAll(script, REDIRECT_ESCAPE, redirectEscape);
        return script;
    }

    protected String getDomainCreationScript() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(HEADER_COMMENT);
        buffer.append(CR).append(CR);
        buffer.append(ENVIRONMENT_COMMENT).append(this.getEnvironment());
        buffer.append(CR).append(CR);
        buffer.append(READ_IN_DOMAIN_TEMPLATE);
        Map infoMap = this.getPropertyInfoMap();
        buffer.append(this.getScriptForKey(KEY_SERVER, (List)infoMap.get(KEY_ADMIN_SERVER), false));
        buffer.append(this.getScriptForKey(KEY_CLUSTER, (List)infoMap.get(KEY_CLUSTER), true));
        buffer.append(this.getScriptForKey(KEY_SERVER, (List)infoMap.get(KEY_SERVER), true));
        buffer.append(this.getScriptForKey(KEY_MACHINE, (List)infoMap.get(KEY_MACHINE), true));
        buffer.append(this.getScriptForKey(KEY_FILE_REALM, (List)infoMap.get(KEY_FILE_REALM), true));
        buffer.append(this.getScriptForKey(KEY_REALM, (List)infoMap.get(KEY_REALM), true));
        buffer.append(this.getScriptForKey(KEY_PASSWORD_POLICY, (List)infoMap.get(KEY_PASSWORD_POLICY), true));
        buffer.append(this.getScriptForKey(KEY_SECURITY_CONFIGURATION, (List)infoMap.get(KEY_SECURITY_CONFIGURATION), true));
        buffer.append(this.getScriptForKey(KEY_SECURITY, (List)infoMap.get(KEY_SECURITY), true));
        buffer.append(this.getScriptForKey(KEY_EMBEDDED_LDAP, (List)infoMap.get(KEY_EMBEDDED_LDAP), true));
        buffer.append(this.getScriptForKey(KEY_JMS_CONNECTION_FACTORY, (List)infoMap.get(KEY_JMS_CONNECTION_FACTORY), true));
        buffer.append(this.getScriptForKey(KEY_JMS_DISTRIBUTED_QUEUE, (List)infoMap.get(KEY_JMS_DISTRIBUTED_QUEUE), true));
        buffer.append(this.getScriptForKey(KEY_JMS_SERVER, (List)infoMap.get(KEY_JMS_SERVER), true));
        buffer.append(this.getScriptForKey(KEY_JMS_TEMPLATE, (List)infoMap.get(KEY_JMS_TEMPLATE), true));
        buffer.append(this.getScriptForKey(KEY_JDBC_CONNECTION_POOL, (List)infoMap.get(KEY_JDBC_CONNECTION_POOL), true));
        buffer.append(this.getScriptForKey(KEY_JTA, (List)infoMap.get(KEY_JTA), true));
        buffer.append(this.getScriptForKey(KEY_JDBC_TX_DATA_SOURCE, (List)infoMap.get(KEY_JDBC_TX_DATA_SOURCE), true));
        buffer.append(this.getScriptForKey(KEY_JMS_JDBC_STORE, (List)infoMap.get(KEY_JMS_JDBC_STORE), true));
        buffer.append(CR).append(CR);
        buffer.append(WRITE_OUT_DOMAIN);
        buffer.append(CR).append(CR);
        buffer.append(CLOSE_TEMPLATE);
        return buffer.toString();
    }

    protected String getScriptForKey(String key, List propertyInfoList, boolean createElement) {
        StringBuffer buffer = new StringBuffer();
        if (propertyInfoList != null && propertyInfoList.size() > 0) {
            String creationOperation = CREATE;
            if (!createElement) {
                creationOperation = FIND;
            }
            for (int i = 0; i < propertyInfoList.size(); ++i) {
                PropertyInfo propertyInfo = (PropertyInfo)propertyInfoList.get(i);
                LinkedHashMap attributeMap = propertyInfo.getAttributeMap();
                String elementName = (String)attributeMap.get(NAME);
                if (elementName == null) {
                    throw new RuntimeException("Key '" + key + "' does not have a required " + NAME + " attribute.");
                }
                String lookupName = (String)attributeMap.get(LOOKUP);
                if (lookupName == null) {
                    lookupName = elementName;
                }
                String lookupVar = key + "_" + lookupName;
                buffer.append(CR).append(CR).append("// Configure ").append(key).append(" ").append(elementName);
                buffer.append(CR).append(creationOperation).append(" ").append(key).append(" \"").append(lookupName).append("\" as ").append(lookupVar).append(";");
                for (String attributeKey : attributeMap.keySet()) {
                    String attributeValue = (String)attributeMap.get(attributeKey);
                    if (attributeKey.equals(NAME) && createElement || attributeKey.equals(ASSIGN) || attributeKey.equals(LOOKUP)) continue;
                    buffer.append(CR).append("set ").append(lookupVar).append(".").append(attributeKey).append(" \"").append(attributeValue).append("\";");
                }
                LinkedHashMap childMap = propertyInfo.getChildMap();
                for (String childKey : childMap.keySet()) {
                    PropertyInfo childInfo = (PropertyInfo)childMap.get(childKey);
                    String childElementName = lookupVar + "_" + childKey;
                    buffer.append(CR).append(CREATE).append(" ").append(key).append(".").append(childKey).append(" \"").append(elementName).append(".").append(elementName).append("\" as ").append(childElementName).append(";");
                    LinkedHashMap childAttributeMap = childInfo.getAttributeMap();
                    for (String childAttributeKey : childAttributeMap.keySet()) {
                        String childAttributeValue = (String)childAttributeMap.get(childAttributeKey);
                        buffer.append(CR).append("set ").append(childElementName).append(".").append(childAttributeKey).append(" \"").append(childAttributeValue).append("\";");
                    }
                }
                String assignmentKey = (String)attributeMap.get(ASSIGN);
                if (!StringUtils.isNotBlank((String)assignmentKey)) continue;
                Map infoMap = this.getPropertyInfoMap();
                List targetElementList = (List)infoMap.get(assignmentKey);
                if (targetElementList == null || targetElementList.size() > 1) {
                    throw new RuntimeException("The \"" + key + "\" configuration assignment " + "refers to a target key of \"" + assignmentKey + "\" which either doesn't exist " + "or contains more than 1 index.");
                }
                PropertyInfo targetPropertyInfo = (PropertyInfo)targetElementList.get(0);
                LinkedHashMap targetAttributeMap = targetPropertyInfo.getAttributeMap();
                String assignmentName = (String)targetAttributeMap.get(NAME);
                if (StringUtils.isBlank((String)assignmentName)) {
                    throw new RuntimeException("The \"" + key + "\" configuration assignment " + "refers to a target key of \"" + assignmentKey + "\" that does not have a \"" + NAME + "\" property defined.");
                }
                buffer.append(CR).append("assign ").append(key).append(" \"").append(lookupName).append("\" to ").append(assignmentKey).append(" \"").append(assignmentName).append("\";");
            }
        }
        return buffer.toString();
    }

    protected String replaceAll(String buffer, String oldValue, String newValue) {
        if (StringUtils.isEmpty((String)buffer) || StringUtils.isEmpty((String)oldValue) || newValue == null) {
            return buffer;
        }
        int index = 0;
        while (index > -1) {
            index = buffer.indexOf(oldValue);
            if (index <= -1) continue;
            buffer = (index == 0 ? "" : buffer.substring(0, index)) + newValue + (index + oldValue.length() >= buffer.length() ? "" : buffer.substring(index + oldValue.length(), buffer.length()));
        }
        return buffer;
    }

    public Map getPropertyInfoMap() {
        return this.propertyInfoMap;
    }

    public void setPropertyInfoMap(Map propertyInfoMap) {
        this.propertyInfoMap = propertyInfoMap;
    }

    public String getUnixTemplate() {
        return this.unixTemplate;
    }

    public void setUnixTemplate(String unixTemplate) {
        this.unixTemplate = unixTemplate;
    }

    public String getWindowsTemplate() {
        return this.windowsTemplate;
    }

    public void setWindowsTemplate(String windowsTemplate) {
        this.windowsTemplate = windowsTemplate;
    }

    public String getUnixOutputFilename() {
        return this.unixOutputFilename;
    }

    public void setUnixOutputFilename(String unixOutputFilename) {
        this.unixOutputFilename = unixOutputFilename;
    }

    public String getWindowsOutputFilename() {
        return this.windowsOutputFilename;
    }

    public void setWindowsOutputFilename(String windowsOutputFilename) {
        this.windowsOutputFilename = windowsOutputFilename;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Usage: PrepareDomainCreationScript <environment> <setup_directory> <properties_filename_suffix> <script_filename_prefix>" + CR + "       (e.g. PrepareDomainCreationScript local setup domain.properties " + "installESR");
            System.exit(0);
        }
        String env = args[0];
        String setupDir = args[1];
        String propFilenameSuffix = args[2];
        String scriptFilenamePrefix = args[3];
        try {
            PrepareDomainCreationScript script = new PrepareDomainCreationScript(env, setupDir, propFilenameSuffix, scriptFilenamePrefix);
            script.create();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

