/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.ExceptionHandler;
import gov.va.med.fw.util.GenericExceptionHandler;
import java.util.HashMap;

public class ExceptionHandlerFactory
extends AbstractComponent {
    private HashMap handlers = null;
    private GenericExceptionHandler defaultHandler = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.defaultHandler == null) {
            this.defaultHandler = new GenericExceptionHandler();
        }
    }

    public HashMap getHandlers() {
        return this.handlers;
    }

    public void setHandlers(HashMap handlers) {
        this.handlers = handlers;
    }

    public GenericExceptionHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(GenericExceptionHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public ExceptionHandler getExceptionHandler(String exceptionName) {
        if (exceptionName == null) {
            throw new IllegalArgumentException("Invalid exception name. Name = " + exceptionName);
        }
        Object handler = null;
        if (this.handlers != null) {
            handler = this.handlers.get(exceptionName);
        }
        return handler == null || !(handler instanceof ExceptionHandler) ? this.defaultHandler : (ExceptionHandler)handler;
    }
}

