/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.struts;

import gov.va.med.fw.ui.DelegatingActionUtils;
import gov.va.med.fw.ui.valuelist.SearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.SelectableResult;
import gov.va.med.fw.ui.valuelist.ValueListException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.mlw.vlh.ValueList;
import net.mlw.vlh.ValueListInfo;
import net.mlw.vlh.web.mvc.ValueListHandlerHelper;
import org.apache.struts.action.ActionForm;
import org.springframework.web.context.WebApplicationContext;

public class ValueListActionUtils {
    private ValueListActionUtils() {
    }

    public static ValueList getValueList(ActionForm form, HttpServletRequest request, String tableId, String valueListAdapterName) throws ValueListException {
        return ValueListActionUtils.getValueList(form, request, tableId, valueListAdapterName, null);
    }

    public static ValueList getValueList(ActionForm form, HttpServletRequest request, String tableId, String valueListAdapterName, List results) throws ValueListException {
        ValueListHandlerHelper valueListHelper = ValueListActionUtils.getValueListHandlerHelper(request);
        ValueListInfo valueListInfo = valueListHelper.getValueListInfo(request, tableId);
        Map filterMap = valueListInfo.getFilters();
        filterMap.put(SearchValueListAdapter.FORM_KEY, form);
        filterMap.put(SearchValueListAdapter.HTTP_REQUEST_KEY, request);
        filterMap.put(SearchValueListAdapter.TABLE_ID_KEY, tableId);
        filterMap.put(SearchValueListAdapter.RESULTS_KEY, results);
        return valueListHelper.getValueList(valueListAdapterName, valueListInfo);
    }

    public static ValueList getSelectableResultValuleList(ActionForm form, HttpServletRequest request, String tableId, String valueListAdapterName, List results) throws ValueListException {
        SearchValueListAdapter.setAction(request, "actionSelect");
        return ValueListActionUtils.getValueList(form, request, tableId, valueListAdapterName, results);
    }

    public static void clearCachedResults(HttpSession session, String tableId) {
        SearchValueListAdapter.setResultsInSession(session, tableId + SearchValueListAdapter.RESULTS_KEY, null);
        SearchValueListAdapter.setPrevPageInSession(session, tableId + SearchValueListAdapter.PREV_PAGE_KEY, null);
    }

    public static boolean isCachedResults(HttpSession session, String tableId) {
        return SearchValueListAdapter.getResultsFromSession(session, tableId + SearchValueListAdapter.RESULTS_KEY) != null;
    }

    public static List getCachedResults(HttpSession session, String tableId) {
        return SearchValueListAdapter.getResultsFromSession(session, tableId + SearchValueListAdapter.RESULTS_KEY);
    }

    public static List getSelectableResults(ValueList valueList, Boolean selected) {
        return ValueListActionUtils.getSelectableResults(valueList.getList(), selected);
    }

    public static List getSelectableResults(List results, Boolean selected) {
        if (selected != null) {
            ArrayList<SelectableResult> updatedList = new ArrayList<SelectableResult>();
            for (SelectableResult selectableResult : results) {
                if (selectableResult.isSelected() != selected.booleanValue()) continue;
                updatedList.add(selectableResult);
            }
            results = updatedList;
        }
        return results;
    }

    public static List getSelectableResultsFromSession(HttpServletRequest request, String tableId, Boolean selected) {
        List wholeResults = SearchValueListAdapter.getResultsFromSession(request.getSession(), tableId + SearchValueListAdapter.RESULTS_KEY);
        return ValueListActionUtils.getSelectableResults(wholeResults, selected);
    }

    public static List getSelectedResultsFromPreviousPage(HttpServletRequest request, String tableId, Boolean selected) {
        List prevPageResults = SearchValueListAdapter.getResultsFromSession(request.getSession(), tableId + SearchValueListAdapter.PREV_PAGE_RESULTS_KEY);
        return ValueListActionUtils.getSelectableResults(prevPageResults, selected);
    }

    public static void setValueList(HttpServletRequest request, ValueList valueList, String requestKey) {
        ValueListActionUtils.getValueListHandlerHelper(request).setValueListTo(request, valueList, requestKey);
    }

    public static ValueListHandlerHelper getValueListHandlerHelper(HttpServletRequest request) {
        return (ValueListHandlerHelper)ValueListActionUtils.getApplicationContext(request).getBean(ValueListHandlerHelper.class.getName(), ValueListHandlerHelper.class);
    }

    public static WebApplicationContext getApplicationContext(HttpServletRequest request) {
        return DelegatingActionUtils.findRequiredWebApplicationContext(request.getSession().getServletContext());
    }
}

