/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.ui.security;

import gov.va.med.fw.security.EncryptionServiceException;
import gov.va.med.fw.security.EncryptionServiceImpl;
import gov.va.med.fw.security.KeyCache;
import gov.va.med.fw.ui.security.UIEncryptionService;
import gov.va.med.fw.util.StringUtils;
import javax.crypto.SecretKey;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;

public class UIEncryptionServiceImpl
extends EncryptionServiceImpl
implements UIEncryptionService {
    private static final char PLUS_SIGN = '+';
    private static final char MINUS_SIGN = '-';
    private static final char EQUAL_SIGN = '=';
    private static final char UNDERSCORE_SIGN = '_';
    protected String encryptionErrorUrl;

    @Override
    public String getEncryptionErrorUrl() {
        return this.encryptionErrorUrl;
    }

    @Override
    public void setEncryptionErrorUrl(String pEncryptionErrorUrl) {
        this.encryptionErrorUrl = pEncryptionErrorUrl;
    }

    @Override
    public String encryptQueryString(ServletRequest request, String value) throws JspException {
        if (!this.isEncryptionEnabled()) {
            return value;
        }
        String url = value;
        try {
            int indexOfQuestion = value.indexOf("?");
            if (indexOfQuestion > 0) {
                String uri = value.substring(0, indexOfQuestion + 1);
                String qs = value.substring(indexOfQuestion + 1);
                qs = StringUtils.replaceHtmlEntities(qs);
                String encryptedQs = this.encrypt(request, qs);
                url = uri + "encry=" + encryptedQs;
            }
        }
        catch (EncryptionServiceException ex) {
            throw new JspException((Throwable)ex);
        }
        return url;
    }

    @Override
    public String encryptHiddenField(ServletRequest request, String value) throws JspException {
        if (!this.isEncryptionEnabled()) {
            return value;
        }
        String encryptedFieldValue = value;
        try {
            if (value != null && value.length() > 0) {
                String encryptedValue = this.encrypt(request, value);
                encryptedFieldValue = "encry:" + encryptedValue;
            }
        }
        catch (EncryptionServiceException ex) {
            throw new JspException((Throwable)ex);
        }
        return encryptedFieldValue;
    }

    @Override
    public String encrypt(ServletRequest request, String clearText) throws EncryptionServiceException {
        SecretKey key;
        String encryptedText = clearText;
        if (request instanceof KeyCache && (key = this.getSecretKey((KeyCache)request, true)) != null) {
            encryptedText = super.encrypt(key, request.getCharacterEncoding(), clearText);
            encryptedText = encryptedText.replace('+', '-').replace('=', '_');
        }
        return encryptedText;
    }

    @Override
    public String decrypt(ServletRequest request, String encryptedText) throws EncryptionServiceException {
        SecretKey key;
        String clearText = encryptedText;
        if (request instanceof KeyCache && (key = this.getSecretKey((KeyCache)request, false)) != null) {
            String encrypted = encryptedText.replace('-', '+').replace('_', '=');
            clearText = super.decrypt(key, request.getCharacterEncoding(), encrypted);
        }
        return clearText;
    }
}

