/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.transaction;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.transaction.TransactionSynchronizationForCacheManager;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.Validate;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionSynchronizationInitializer
extends AbstractComponent
implements MethodInterceptor {
    private Set transactionSynchronizations;
    private TransactionTimestampManager timestampManager;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            List alreadyRegisteredSyncs = TransactionSynchronizationManager.getSynchronizations();
            Iterator itrSyncsToAdd = this.transactionSynchronizations != null ? this.transactionSynchronizations.iterator() : null;
            String syncName = null;
            HashSet<String> justAddedSyncs = new HashSet<String>();
            boolean tsAdded = false;
            while (itrSyncsToAdd != null && itrSyncsToAdd.hasNext()) {
                syncName = (String)itrSyncsToAdd.next();
                Iterator itr = alreadyRegisteredSyncs != null ? alreadyRegisteredSyncs.iterator() : null;
                Object sync = null;
                boolean alreadyAdded = false;
                while (itr != null && itr.hasNext()) {
                    sync = itr.next();
                    if (!(sync instanceof AbstractComponent) || !((AbstractComponent)sync).getBeanName().equals(syncName)) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded || justAddedSyncs.contains(syncName)) continue;
                justAddedSyncs.add(syncName);
                TransactionSynchronization syncInstance = (TransactionSynchronization)this.getApplicationContext().getBean(syncName);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)syncInstance);
                if (syncInstance instanceof TransactionSynchronizationForCacheManager) {
                    TransactionSynchronizationManager.bindResource((Object)TransactionSynchronizationForCacheManager.CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION, (Object)Boolean.TRUE.toString());
                }
                if (tsAdded) continue;
                this.timestampManager.intializeTransactionTimestamp(true);
                tsAdded = true;
            }
        }
        return invocation.proceed();
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.transactionSynchronizations, (String)"can not use this class without transactionSynchronizations");
        Validate.notNull((Object)((Object)this.timestampManager));
    }

    public Set getTransactionSynchronizations() {
        return this.transactionSynchronizations;
    }

    public void setTransactionSynchronizations(Set transactionSynchronizations) {
        this.transactionSynchronizations = transactionSynchronizations;
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }
}

