/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.jms;

import gov.va.med.fw.service.ServiceConfigurationException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.jms.AbstractMessageProducerService;
import gov.va.med.fw.service.jms.JMSServiceException;
import gov.va.med.fw.service.jms.TopicDescriptor;
import gov.va.med.fw.service.jms.TopicMessageProducer;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.springframework.jms.support.JmsUtils;

public class TopicMessageProducerService
extends AbstractMessageProducerService
implements TopicMessageProducer {
    private static final long serialVersionUID = 2808696406833332275L;
    private TopicDescriptor descriptor = null;

    public TopicDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(TopicDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.descriptor == null) {
            throw new ServiceConfigurationException("Required JMS descriptor property needs to be configured");
        }
    }

    @Override
    public void publish(Object object, Properties properties) throws ServiceException {
        this.publish(object, properties, 2, 4, 0L);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void publish(Object object, Properties properties, int deliverymode, int priority, long timeToLive) throws ServiceException {
        if (object == null || properties == null || properties.isEmpty()) {
            throw new ServiceConfigurationException("Invalid message and properties");
        }
        TopicConnection connection = null;
        TopicSession session = null;
        boolean transactedJMSSession = !super.isSupportsDistributedTransactions();
        int sessionAckMode = 1;
        List providerURLs = this.descriptor.getProviderURLs();
        Iterator itr = providerURLs.iterator();
        String providerURL = null;
        while (itr.hasNext()) {
            providerURL = (String)itr.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Connecting to JMS server at: " + providerURL));
            }
            try {
                connection = this.descriptor.createTopicConnection(providerURL);
                session = this.descriptor.createTopicSession(connection, transactedJMSSession, sessionAckMode);
                break;
            }
            catch (ServiceException e) {
                this.logger.error((Object)("Unable to establish JMS connectivity to " + providerURL + " due to exception: "), (Throwable)e);
                JmsUtils.closeSession((Session)session);
                session = null;
                JmsUtils.closeConnection((Connection)connection);
                connection = null;
                if (!itr.hasNext()) {
                    throw e;
                }
                this.logger.error((Object)"...Attempting fallback to lower priority providerURL");
            }
        }
        TopicPublisher publisher = null;
        try {
            publisher = session.createPublisher(this.descriptor.getTopic(providerURL));
            publisher.setDeliveryMode(deliverymode);
            publisher.setPriority(priority);
            publisher.setTimeToLive(timeToLive);
            publisher.setDisableMessageTimestamp(false);
            publisher.setDisableMessageID(false);
            Message jmsMessage = this.createJMSMessageByType((Session)session, object, properties);
            publisher.publish(jmsMessage);
        }
        catch (MessageFormatException e) {
            try {
                throw new JMSServiceException("Invalid meessage format.", e);
                catch (InvalidDestinationException e2) {
                    throw new JMSServiceException("Invalid message queue.", e2);
                }
                catch (JMSException e3) {
                    throw new JMSServiceException("Failed to send a meessage.", e3);
                }
                catch (UnsupportedOperationException e4) {
                    throw new JMSServiceException("Missing a valid queue.", e4);
                }
            }
            catch (Throwable throwable) {
                JmsUtils.closeMessageProducer(publisher);
                publisher = null;
                this.close((Session)session);
                session = null;
                JmsUtils.closeConnection((Connection)connection);
                connection = null;
                throw throwable;
            }
        }
        JmsUtils.closeMessageProducer((MessageProducer)publisher);
        publisher = null;
        this.close((Session)session);
        session = null;
        JmsUtils.closeConnection((Connection)connection);
    }
}

