/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.MapFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.ChildBeanDefinition;

public class InheritedMapFactoryBean
extends MapFactoryBean
implements BeanFactoryAware,
BeanNameAware {
    private BeanFactory factory = null;
    private String name = null;
    private boolean inherited = false;

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = factory;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setInherited(boolean flag) {
        this.inherited = flag;
    }

    protected Object createInstance() {
        Map beans = (Map)super.createInstance();
        if (this.inherited) {
            Map parentMap = null;
            ConfigurableListableBeanFactory confFactory = this.factory instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)this.factory : null;
            BeanDefinition def = confFactory != null ? confFactory.getBeanDefinition(this.name) : null;
            ChildBeanDefinition childDef = def instanceof ChildBeanDefinition ? (ChildBeanDefinition)def : null;
            String parentBeanName = childDef != null ? childDef.getParentName() : null;
            parentMap = this.getParentMap(confFactory, parentBeanName);
            beans = this.populateMap(beans, parentMap);
        }
        return beans;
    }

    private Map getParentMap(ConfigurableListableBeanFactory confFactory, String parentBeanName) {
        BeanDefinition def = null;
        BeanFactory parentFactory = null;
        Map parentMap = null;
        if (parentBeanName != null) {
            while (confFactory != null) {
                try {
                    def = confFactory.getBeanDefinition(parentBeanName);
                    break;
                }
                catch (NoSuchBeanDefinitionException ex) {
                    parentFactory = confFactory.getParentBeanFactory();
                    confFactory = parentFactory instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)parentFactory : null;
                }
            }
            if (def == null) {
                throw new NoSuchBeanDefinitionException(parentBeanName, "Parent bean name not found in current or any parent BeanFactories");
            }
        }
        if (!def.isAbstract()) {
            Object obj = confFactory.getBean(parentBeanName, this.getObjectType());
            parentMap = obj instanceof Map ? (Map)obj : null;
        } else {
            MutablePropertyValues values = def.getPropertyValues();
            PropertyValue value = values.getPropertyValue("sourceMap");
            Object propValue = value.getValue();
            Map valueMap = propValue instanceof Map ? (Map)propValue : null;
            parentMap = this.resolveListElement(value, valueMap, (AbstractBeanFactory)confFactory);
        }
        return parentMap;
    }

    private Map populateMap(Map source, Map target) {
        Map beans = source;
        if (source != null && target != null) {
            source.putAll(target);
        }
        return beans;
    }

    private Map resolveListElement(PropertyValue value, Map valueMap, AbstractBeanFactory factory) {
        Iterator i;
        HashMap resolvedMap = new HashMap();
        Iterator iterator = i = valueMap != null ? valueMap.entrySet().iterator() : null;
        while (factory != null && value != null && i != null && i.hasNext()) {
            Map.Entry entry = i.next();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder holder = (BeanDefinitionHolder)entryValue;
                BeanDefinition beanDef = holder.getBeanDefinition();
                String beanName = holder.getBeanName();
                BeanDefinitionValueResolver resolver = new BeanDefinitionValueResolver(factory, beanName != null ? beanName : "(inner-bean)", beanDef);
                entryValue = resolver.resolveValueIfNecessary(value.getName(), entryValue);
            } else if (entryValue instanceof RuntimeBeanReference) {
                String beanName = ((RuntimeBeanReference)entryValue).getBeanName();
                entryValue = factory.getBean(beanName);
            }
            resolvedMap.put(entryKey, entryValue);
        }
        return resolvedMap;
    }
}

