/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.service.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.ChildBeanDefinition;

public class InheritedListFactoryBean
extends ListFactoryBean
implements BeanFactoryAware,
BeanNameAware {
    private BeanFactory factory = null;
    private String name = null;
    private boolean inherited = false;

    protected Object createInstance() {
        List beans = (List)super.createInstance();
        if (this.inherited) {
            List parentList = null;
            ConfigurableListableBeanFactory confFactory = this.factory instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)this.factory : null;
            BeanDefinition def = confFactory != null ? confFactory.getBeanDefinition(this.name) : null;
            ChildBeanDefinition childDef = def instanceof ChildBeanDefinition ? (ChildBeanDefinition)def : null;
            String parentBeanName = childDef != null ? childDef.getParentName() : null;
            parentList = this.getParentList(confFactory, parentBeanName);
            beans = this.populateList(beans, parentList);
        }
        return beans;
    }

    private List getParentList(ConfigurableListableBeanFactory confFactory, String parentBeanName) {
        BeanDefinition def = null;
        BeanFactory parentFactory = null;
        List parentList = null;
        if (parentBeanName != null) {
            while (confFactory != null) {
                try {
                    def = confFactory.getBeanDefinition(parentBeanName);
                    break;
                }
                catch (NoSuchBeanDefinitionException ex) {
                    parentFactory = confFactory.getParentBeanFactory();
                    confFactory = parentFactory instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)parentFactory : null;
                }
            }
            if (def == null) {
                throw new NoSuchBeanDefinitionException(parentBeanName, "Parent bean name not found in current or any parent BeanFactories");
            }
        }
        if (def != null) {
            if (!def.isAbstract()) {
                Object obj = confFactory.getBean(parentBeanName, this.getObjectType());
                parentList = obj instanceof List ? (List)obj : null;
            } else {
                MutablePropertyValues values = def.getPropertyValues();
                PropertyValue value = values.getPropertyValue("sourceList");
                Object propValue = value.getValue();
                List valueList = propValue instanceof List ? (List)propValue : null;
                parentList = this.resolveListElement(value, valueList, (AbstractBeanFactory)confFactory);
            }
        }
        return parentList;
    }

    private List populateList(List source, List target) {
        List beans = source;
        if (source != null) {
            Iterator itr = target != null ? target.iterator() : null;
            Object obj = null;
            while (itr != null && itr.hasNext()) {
                obj = itr.next();
                if (obj instanceof List) {
                    source = ListUtils.sum((List)source, (List)((List)obj));
                    continue;
                }
                source.add(obj);
            }
        }
        return beans;
    }

    private List resolveListElement(PropertyValue value, List valueList, AbstractBeanFactory factory) {
        Iterator i;
        ArrayList resolvedList = new ArrayList();
        Iterator iterator = i = valueList != null ? valueList.iterator() : null;
        while (factory != null && value != null && i != null && i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder holder = (BeanDefinitionHolder)obj;
                BeanDefinition beanDef = holder.getBeanDefinition();
                String beanName = holder.getBeanName();
                BeanDefinitionValueResolver resolver = new BeanDefinitionValueResolver(factory, beanName != null ? beanName : "(inner-bean)", beanDef);
                obj = resolver.resolveValueIfNecessary(value.getName(), obj);
            } else if (obj instanceof RuntimeBeanReference) {
                String beanName = ((RuntimeBeanReference)obj).getBeanName();
                obj = factory.getBean(beanName);
            }
            resolvedList.add(obj);
        }
        return resolvedList;
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = factory;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setInherited(boolean flag) {
        this.inherited = flag;
    }
}

