/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security.jaas;

import gov.va.med.fw.security.jaas.AbstractLoginModule;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public abstract class AbstractUserPasswordLoginModule
extends AbstractLoginModule {
    private static final String LOGIN_NAME = "javax.security.auth.login.name";
    private static final String LOGIN_PASSWORD = "javax.security.auth.login.password";
    private String username = null;
    private char[] password = null;
    private List principalsList = null;
    private List pendingPrincipalsList = null;
    private boolean commitSucceeded = false;
    private boolean succeeded = false;

    protected abstract List authenticate(String var1, char[] var2) throws LoginException;

    @Override
    public boolean login() throws LoginException {
        if (this.isTryFirstPass()) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                this.debugIfOn("tryFirstPass succeeded");
                return true;
            }
            catch (LoginException ex) {
                this.cleanState();
                this.debugIfOn("tryFirstPass failed. Reason:" + ex.toString());
            }
        } else if (this.isUseFirstPass()) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                this.debugIfOn("useFirstPass succeeded");
                return true;
            }
            catch (LoginException ex) {
                this.cleanState();
                this.debugIfOn("useFirstPass failed");
                throw ex;
            }
        }
        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            this.debugIfOn("regular authentication succeeded for user " + this.username);
            return true;
        }
        catch (LoginException ex) {
            this.debugIfOn("regular authentication failed for user " + this.username);
            this.cleanState();
            throw ex;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded || this.pendingPrincipalsList == null) {
            return false;
        }
        if (this.getSubject().isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is Readonly");
        }
        this.principalsList = new ArrayList();
        Set<Principal> principals = this.subject.getPrincipals();
        for (int p = 0; p < this.pendingPrincipalsList.size(); ++p) {
            Principal principal = (Principal)this.pendingPrincipalsList.get(p);
            if (!principals.contains(principal)) {
                principals.add(principal);
            }
            this.principalsList.add(principal);
        }
        this.cleanState();
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.debugIfOn("abort for user " + this.username);
        if (!this.succeeded || this.pendingPrincipalsList == null) {
            return false;
        }
        if (this.succeeded && this.pendingPrincipalsList != null && !this.commitSucceeded) {
            this.succeeded = false;
            this.pendingPrincipalsList = null;
            this.cleanState();
        } else {
            this.logout();
        }
        this.debugIfOn("aborted authentication for user " + this.username);
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.debugIfOn("logout for user " + this.username);
        if (this.subject.isReadOnly()) {
            this.cleanState();
            throw new LoginException("Subject is Readonly");
        }
        Set<Principal> principals = this.subject.getPrincipals();
        for (int p = 0; p < this.principalsList.size(); ++p) {
            principals.remove(this.principalsList.get(p));
        }
        this.pendingPrincipalsList = null;
        this.principalsList = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.debugIfOn("user " + this.username + " logged out.");
        return true;
    }

    private void attemptAuthentication(boolean fromSharedState) throws LoginException {
        this.setUsernameAndPassword(fromSharedState);
        this.debugIfOn("Trying to authenticate user " + this.username);
        this.pendingPrincipalsList = this.authenticate(this.username, this.password);
        this.storePasswordIfRequired(this.username, this.password);
    }

    private void storePasswordIfRequired(String username, char[] password) {
        if (this.isStorePass() && !this.getSharedState().containsKey(LOGIN_NAME) && !this.getSharedState().containsKey(LOGIN_PASSWORD)) {
            this.debugIfOn("Storing username and password in shared state.");
            this.sharedState.put(LOGIN_NAME, username);
            this.sharedState.put(LOGIN_PASSWORD, password);
        }
    }

    private void setUsernameAndPassword(boolean fromSharedState) throws LoginException {
        if (fromSharedState) {
            this.debugIfOn("Loading username and password information from shared state.");
            this.username = (String)this.getSharedState().get(LOGIN_NAME);
            this.password = (char[])this.getSharedState().get(LOGIN_PASSWORD);
            return;
        }
        if (this.callbackHandler == null) {
            throw new LoginException("Missing CallbackHandler.");
        }
        this.debugIfOn("Using CallbackHandler to get the username and password.");
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            this.password = ((PasswordCallback)callbacks[1]).getPassword();
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (IOException ex) {
            throw new LoginException("Exception while getting user information from callback handler. " + ex.toString());
        }
        catch (UnsupportedCallbackException ex) {
            throw new LoginException("Unsupported CallbackHandler " + ex.getCallback().toString());
        }
    }

    private void cleanState() {
        this.username = null;
        if (this.password != null) {
            Arrays.fill(this.password, ' ');
            this.password = null;
        }
        if (this.isClearPass()) {
            this.debugIfOn("Removing username/password from shared state.");
            this.sharedState.remove(LOGIN_NAME);
            this.sharedState.remove(LOGIN_PASSWORD);
        }
    }

    protected void debugIfOn(String msg) {
        if (this.isDebug()) {
            this.logDebug(msg);
        }
    }

    protected abstract void logDebug(String var1);
}

