/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;

public abstract class AbstractLoginModule
implements LoginModule {
    private static final String OPTION_TRYFIRSTPASS = "tryFirstPass";
    private static final String OPTION_USEFIRSTPASS = "useFirstPass";
    private static final String OPTION_STOREPASS = "storePass";
    private static final String OPTION_CLEARPASS = "clearPass";
    private static final String OPTION_DEBUG = "debug";
    private static final String TRUE = "true";
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map sharedState;
    protected Map options;
    private boolean debug = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean useFirstPass = false;
    private boolean clearPass = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = this.getOptionAsBoolean(OPTION_DEBUG);
        this.tryFirstPass = this.getOptionAsBoolean(OPTION_TRYFIRSTPASS);
        this.useFirstPass = this.getOptionAsBoolean(OPTION_USEFIRSTPASS);
        this.storePass = this.getOptionAsBoolean(OPTION_STOREPASS);
        this.clearPass = this.getOptionAsBoolean(OPTION_CLEARPASS);
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Map getOptions() {
        return this.options;
    }

    public Map getSharedState() {
        return this.sharedState;
    }

    public Subject getSubject() {
        return this.subject;
    }

    protected Object getOption(String key) {
        return this.options.get(key);
    }

    protected String getOptionAsString(String key) {
        Object val = this.getOption(key);
        return val == null ? null : val.toString();
    }

    protected boolean getOptionAsBoolean(String key) {
        return TRUE.equalsIgnoreCase((String)this.options.get(key));
    }

    public boolean isClearPass() {
        return this.clearPass;
    }

    public boolean isStorePass() {
        return this.storePass;
    }

    public boolean isTryFirstPass() {
        return this.tryFirstPass;
    }

    public boolean isUseFirstPass() {
        return this.useFirstPass;
    }
}

