/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.security;

import gov.va.med.fw.security.AuthenticationToken;
import gov.va.med.fw.security.UserPrincipal;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.jaas.JaasAuthenticationCallbackHandler;
import org.acegisecurity.providers.jaas.JaasAuthenticationProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContextAware;

public class JaasAuthenticationProviderImpl
extends JaasAuthenticationProvider
implements AuthenticationProvider,
InitializingBean,
ApplicationContextAware {
    private String loginConfigFile = "/jaas.login.conf";
    private boolean allowUserAsAuthority = true;

    public boolean isAllowUserAsAuthority() {
        return this.allowUserAsAuthority;
    }

    public void setAllowUserAsAuthority(boolean allowUserAsAuthority) {
        this.allowUserAsAuthority = allowUserAsAuthority;
    }

    public String getLoginConfigFile() {
        return this.loginConfigFile;
    }

    public void setLoginConfigFile(String loginConfigFile) {
        this.loginConfigFile = loginConfigFile;
    }

    public void afterPropertiesSet() throws Exception {
        URL confFileUrl = ((Object)((Object)this)).getClass().getResource(this.loginConfigFile);
        System.setProperty("java.security.auth.login.config", confFileUrl.toString());
    }

    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        if (auth instanceof AuthenticationToken) {
            AuthenticationToken authToken = (AuthenticationToken)auth;
            if (authToken.isLoggedIn()) {
                return auth;
            }
            try {
                LoginContext loginContext = new LoginContext(this.getLoginContextName(), new InternalCallbackHandler(auth));
                loginContext.login();
                HashSet<Object> authorities = new HashSet<Object>();
                if (authToken.getAuthorities() != null) {
                    authorities.addAll(Arrays.asList(authToken.getAuthorities()));
                }
                Set<Principal> principals = loginContext.getSubject().getPrincipals();
                for (Principal principal : principals) {
                    if (!(principal instanceof UserPrincipal)) continue;
                    UserPrincipal userPrincipal = (UserPrincipal)principal;
                    authToken.setUserPrincipal(userPrincipal);
                    if (this.allowUserAsAuthority) {
                        authorities.add(new GrantedAuthorityImpl(userPrincipal.getName()));
                    }
                    authorities.addAll(userPrincipal.getAuthorities());
                }
                AuthenticationToken result = new AuthenticationToken(authToken.getPrincipal(), authToken.getCredentials(), authorities.toArray(new GrantedAuthority[authorities.size()]));
                result.setUserPrincipal(authToken.getUserPrincipal());
                result.setLoggedIn(true);
                this.publishSuccessEvent(result);
                return result;
            }
            catch (LoginException loginException) {
                authToken.setLoggedIn(false);
                AcegiSecurityException ase = this.getLoginExceptionResolver().resolveException(loginException);
                this.publishFailureEvent(authToken, ase);
                throw ase;
            }
        }
        return null;
    }

    public Authentication authenticateOld(Authentication auth) throws AuthenticationException {
        if (auth instanceof AuthenticationToken) {
            AuthenticationToken authToken = (AuthenticationToken)auth;
            if (authToken.isLoggedIn()) {
                return auth;
            }
            try {
                LoginContext lc = new LoginContext(this.getLoginContextName(), new InternalCallbackHandler(auth));
                lc.login();
                this.successfulJaasAuthentication(lc, authToken);
                return authToken;
            }
            catch (LoginException loginException) {
                authToken.setLoggedIn(false);
                authToken.setAuthenticated(false);
                AcegiSecurityException ase = this.getLoginExceptionResolver().resolveException(loginException);
                this.publishFailureEvent(authToken, ase);
                throw ase;
            }
        }
        return null;
    }

    private void successfulJaasAuthentication(LoginContext lc, AuthenticationToken authToken) {
        HashSet<Object> authorities = new HashSet<Object>();
        if (authToken.getAuthorities() != null) {
            authorities.addAll(Arrays.asList(authToken.getAuthorities()));
        }
        Set<Principal> principals = lc.getSubject().getPrincipals();
        for (Principal principal : principals) {
            if (!(principal instanceof UserPrincipal)) continue;
            UserPrincipal userPrincipal = (UserPrincipal)principal;
            authToken.setUserPrincipal(userPrincipal);
            if (this.allowUserAsAuthority) {
                authorities.add(new GrantedAuthorityImpl(userPrincipal.getName()));
            }
            authorities.addAll(userPrincipal.getAuthorities());
        }
        authToken.setLoggedIn(true);
        this.publishSuccessEvent(authToken);
    }

    public boolean supports(Class aClass) {
        return AuthenticationToken.class.isAssignableFrom(aClass);
    }

    private class InternalCallbackHandler
    implements CallbackHandler {
        private Authentication authentication;

        public InternalCallbackHandler(Authentication authentication) {
            this.authentication = authentication;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            JaasAuthenticationCallbackHandler[] callbackHandlers = JaasAuthenticationProviderImpl.this.getCallbackHandlers();
            for (int i = 0; i < callbackHandlers.length; ++i) {
                JaasAuthenticationCallbackHandler handler = callbackHandlers[i];
                for (int j = 0; j < callbacks.length; ++j) {
                    Callback callback = callbacks[j];
                    handler.handle(callback, this.authentication);
                }
            }
        }
    }
}

