/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import gov.va.med.fw.service.AbstractComponent;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;

public class ScheduledProcessListener
extends AbstractComponent
implements TriggerListener {
    private String name;

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        if (this.logger.isInfoEnabled()) {
            StringBuffer buf = new StringBuffer();
            buf.append("ScheduledProcessListener.triggerFired at ");
            buf.append(new Date()).append(": ").append(trigger.getJobGroup()).append(".").append(trigger.getJobName());
            buf.append(" with merged trigger/job data: ");
            Map data = context.getMergedJobDataMap().getWrappedMap();
            Iterator itr = data != null ? data.entrySet().iterator() : null;
            Map.Entry entry = null;
            while (itr != null && itr.hasNext()) {
                entry = itr.next();
                if (entry.getValue() instanceof Object[]) {
                    Object[] array = (Object[])entry.getValue();
                    for (int i = 0; i < array.length; ++i) {
                        buf.append(entry.getKey()).append("[").append(i).append("]=").append(array[i]);
                        if (i + 1 >= array.length) continue;
                        buf.append(",");
                    }
                } else {
                    buf.append(entry.getKey()).append("=").append(entry.getValue());
                }
                if (!itr.hasNext()) continue;
                buf.append(", ");
            }
            this.logger.info((Object)buf.toString());
        }
    }

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ScheduledProcessListener.vetoJobExecution at " + new Date() + ": " + trigger.getJobGroup() + "." + trigger.getJobName()));
        }
        return false;
    }

    public void triggerMisfired(Trigger trigger) {
        if (this.logger.isInfoEnabled()) {
            Date now = new Date();
            Date fireTimeThatMisfired = trigger.getNextFireTime();
            this.logger.info((Object)("ScheduledProcessListener.triggerMisfired detected at " + now + " (should have triggered at " + fireTimeThatMisfired + "): " + trigger.getJobGroup() + "." + trigger.getJobName()));
        }
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, int triggerInstructionCode) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ScheduledProcessListener.triggerComplete at " + new Date() + ": " + trigger.getJobGroup() + "." + trigger.getJobName()));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

