/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import gov.va.med.fw.service.AbstractComponent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Calendar;
import org.apache.commons.lang.ClassUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.Trigger;

public class ScheduledJobListener
extends AbstractComponent
implements JobListener {
    private String jobToBeFiredMessage = "Job {1}.{0} fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private String jobSuccessMessage = "Job {1}.{0} execution complete at {2, date, HH:mm:ss MM/dd/yyyy}.  Next fired time is {3}";
    private String jobFailedMessage = "Job {1}.{0} execution failed at {2, date, HH:mm:ss MM/dd/yyyy} due to [{3}].  Next fired time is {4}";
    private String jobWasVetoedMessage = "Job {1}.{0} was vetoed.  It was to be fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private String name = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        this.name = this.getBeanName();
    }

    public String getName() {
        return this.name;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (this.logger.isInfoEnabled()) {
            Trigger trigger = context.getTrigger();
            Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), Calendar.getInstance().getTime(), trigger.getName(), trigger.getGroup()};
            this.logger.info((Object)(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + ".jobToBeExecuted"));
            this.logger.info((Object)MessageFormat.format(this.jobToBeFiredMessage, args));
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        if (this.logger.isInfoEnabled()) {
            Trigger trigger = context.getTrigger();
            Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), Calendar.getInstance().getTime(), trigger.getName(), trigger.getGroup()};
            this.logger.info((Object)(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + ".jobExecutionVetoed"));
            this.logger.info((Object)MessageFormat.format(this.jobWasVetoedMessage, args));
        }
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException exception) {
        Trigger trigger = context.getTrigger();
        if (exception != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + ".jobWasExecuted"));
                Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), Calendar.getInstance().getTime(), exception.getMessage(), trigger.getNextFireTime()};
                this.logger.info((Object)MessageFormat.format(this.jobFailedMessage, args));
                StringWriter errorWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(errorWriter);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                this.logger.info((Object)("Detail Stack Trace: " + errorWriter.toString()));
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + ".jobWasExecuted"));
            Object[] args = new Object[]{context.getJobDetail().getName(), context.getJobDetail().getGroup(), Calendar.getInstance().getTime(), trigger.getNextFireTime()};
            this.logger.info((Object)MessageFormat.format(this.jobSuccessMessage, args));
        }
    }
}

