/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.scheduling.TriggerStatus;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.springframework.beans.factory.InitializingBean;

public class QuartzSchedulingService
extends AbstractComponent
implements Serializable,
SchedulingService {
    private static final long serialVersionUID = 3171280925841379597L;
    private static int TRIGGER_NAME_MAX_LENGTH = 80;
    private Scheduler scheduler = null;
    private String immediateTriggerKey;
    private String futureTriggerKey;
    private boolean isClustered = false;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.scheduler, (String)"A scheduler must be configured");
        Validate.notNull((Object)this.immediateTriggerKey, (String)"A immediateTriggerKey must be configured");
        Validate.notNull((Object)this.futureTriggerKey, (String)"A futureTriggerKey must be configured");
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    @Override
    public void setIsClustered(boolean flag) {
        this.isClustered = flag;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public String getFutureTriggerKey() {
        return this.futureTriggerKey;
    }

    @Override
    public void setFutureTriggerKey(String futureTriggerKey) {
        this.futureTriggerKey = futureTriggerKey;
    }

    @Override
    public String getImmediateTriggerKey() {
        return this.immediateTriggerKey;
    }

    @Override
    public void setImmediateTriggerKey(String immediateTriggerKey) {
        this.immediateTriggerKey = immediateTriggerKey;
    }

    @Override
    public Date schedule(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        return this.scheduleJob(jobDetail, trigger);
    }

    private Date scheduleJob(Trigger trigger) throws SchedulerException {
        return this.scheduleJob(null, trigger);
    }

    private Date scheduleJob(JobDetail job, Trigger trigger) throws SchedulerException {
        boolean ok = false;
        Date date = null;
        boolean i = true;
        String baseTriggerName = trigger.getName();
        try {
            if (trigger.getName().length() > TRIGGER_NAME_MAX_LENGTH) {
                trigger.setName(StringUtils.substring((String)trigger.getName(), (int)(trigger.getName().length() - TRIGGER_NAME_MAX_LENGTH), (int)trigger.getName().length()));
            }
            date = job != null ? this.getScheduler().scheduleJob(job, trigger) : this.getScheduler().scheduleJob(trigger);
            ok = true;
        }
        catch (JobPersistenceException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)("Error while Scheduling Trigger[ TriggerName[" + trigger.getName() + "]" + " in group [" + trigger.getGroup() + "]}"), (Throwable)e);
            }
            if (e instanceof ObjectAlreadyExistsException) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Error while Scheduling Trigger[ TriggerName[" + trigger.getName() + "]" + " in group [" + trigger.getGroup() + "]  But failed with Object Already Exists Exception, NO Need to create the trigger!"));
                }
            }
            throw e;
        }
        return date;
    }

    @Override
    public Date schedule(JobDetail jobDetail, List contextDataForThisTrigger, double numberOfHoursDelayed, String triggerName, String triggerGroup) throws SchedulerException {
        String jobName = jobDetail.getName();
        String jobGroup = jobDetail.getGroup();
        SimpleTrigger trigger = this.getSimpleTrigger(this.futureTriggerKey, jobDetail, triggerName, triggerGroup, false);
        trigger.setJobName(jobName);
        trigger.setJobGroup(jobGroup);
        trigger.setName(triggerName);
        trigger.setGroup(triggerGroup);
        long millis = Math.round(numberOfHoursDelayed * 60.0) * 60L * 1000L;
        trigger.setStartTime(new Date(System.currentTimeMillis() + millis));
        if (contextDataForThisTrigger != null && !contextDataForThisTrigger.isEmpty()) {
            trigger.getJobDataMap().put((Object)"methodArguments", (Object)contextDataForThisTrigger.toArray());
        } else {
            trigger.getJobDataMap().remove((Object)"methodArguments");
        }
        return this.schedule(jobDetail, (Trigger)trigger);
    }

    @Override
    public Date schedule(Trigger trigger) throws SchedulerException {
        return this.scheduleJob(trigger);
    }

    @Override
    public void fireJobWithImmediateTrigger(ScheduledProcessInvocationContext invocationContext) throws SchedulerException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Scheduling job[" + invocationContext.getJobName() + "]" + " in group [" + invocationContext.getJobGroup() + "] for immediate execution"));
        }
        this.schedule((Trigger)this.getSimpleTrigger(this.immediateTriggerKey, invocationContext));
    }

    @Override
    public void fireJobWithImmediateTrigger(JobDetail job) throws SchedulerException {
        Validate.notNull((Object)job, (String)"A job must not be null");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Scheduling job[" + job.getName() + "]" + " in group [" + job.getGroup() + "] for immediate execution"));
        }
        this.schedule((Trigger)this.getSimpleTrigger(this.immediateTriggerKey, job, null, null, true));
    }

    @Override
    public void fireJobWithImmediateTrigger(TriggerEvent event) throws SchedulerException {
        this.fireJobWithImmediateTrigger((ScheduledProcessInvocationContext)event.getPayload());
    }

    @Override
    public boolean unschedule(String triggerName, String groupName) throws SchedulerException {
        Trigger trigger = this.getTrigger(triggerName, groupName);
        return trigger != null && this.getScheduler().unscheduleJob(triggerName, groupName);
    }

    @Override
    public Date reschedule(String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        return this.getScheduler().rescheduleJob(triggerName, groupName, newTrigger);
    }

    @Override
    public boolean interrupt(String jobName, String groupName) throws SchedulerException {
        Validate.notNull((Object)jobName, (String)"JobName must not be null.");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Interrupting a job[" + jobName + "]" + " in group [" + groupName + "] ."));
        }
        return this.getScheduler().interrupt(jobName, groupName);
    }

    @Override
    public boolean interrupt(JobDetail jobDetail) throws SchedulerException {
        Validate.notNull((Object)jobDetail, (String)"JobDetail must not be null.");
        return this.interrupt(jobDetail.getName(), jobDetail.getGroup());
    }

    @Override
    public String[] getJobGroupNames() throws SchedulerException {
        return this.scheduler.getJobGroupNames();
    }

    @Override
    public String[] getJobNames(String groupName) throws SchedulerException {
        return this.scheduler.getJobNames(groupName);
    }

    @Override
    public String[] getTriggerGroupNames() throws SchedulerException {
        return this.scheduler.getTriggerGroupNames();
    }

    @Override
    public String[] getTriggerNames(String groupName) throws SchedulerException {
        return this.scheduler.getTriggerNames(groupName);
    }

    @Override
    public JobDetail getJobDetail(String jobName, String jobGroup) throws SchedulerException {
        return this.scheduler.getJobDetail(jobName, jobGroup);
    }

    @Override
    public Trigger getTrigger(String triggerName, String triggerGroup) throws SchedulerException {
        return this.scheduler.getTrigger(triggerName, triggerGroup);
    }

    @Override
    public TriggerStatus getTriggerStatus(String triggerName, String triggerGroup) throws SchedulerException {
        Trigger trigger = this.getTrigger(triggerName, triggerGroup);
        TriggerStatus status = new TriggerStatus();
        if (trigger != null) {
            status.setNextFireTime(trigger.getNextFireTime());
            int quartzStatus = this.scheduler.getTriggerState(triggerName, triggerGroup);
            if (quartzStatus == 0) {
                status.setStatus(TriggerStatus.NORMAL_STATUS);
            } else if (quartzStatus == 3) {
                status.setStatus("ERROR");
            } else if (quartzStatus == 2) {
                status.setStatus("COMPLETE");
            } else if (quartzStatus == 1) {
                status.setStatus(TriggerStatus.PAUSED_STATUS);
            } else if (quartzStatus == 4) {
                status.setStatus("BLOCKED");
            } else {
                status.setStatus("" + quartzStatus);
            }
        }
        return status;
    }

    private SimpleTrigger getSimpleTrigger(String triggerKey, ScheduledProcessInvocationContext context) throws SchedulerException {
        try {
            Object component = this.getComponent(context.getJobDetailBeanName(), JobDetail.class);
            JobDetail job = component instanceof JobDetail ? (JobDetail)component : null;
            job.setName(context.getJobName());
            job.setGroup(context.getJobGroup());
            SimpleTrigger trigger = this.getSimpleTrigger(triggerKey, job, null, null, true);
            if (context.getInvocationArguments() != null) {
                trigger.getJobDataMap().put((Object)"methodArguments", context.getInvocationArguments());
            } else {
                trigger.getJobDataMap().remove((Object)"methodArguments");
            }
            trigger.getJobDataMap().put("executionContext", context.getExecutionContext());
            return trigger;
        }
        catch (Throwable t) {
            InvalidConfigurationException e = new InvalidConfigurationException("Unable to get a SimpleTrigger for job", t);
            throw new SchedulerException("Unable to trigger task immediately", (Exception)e);
        }
    }

    private SimpleTrigger getSimpleTrigger(String triggerKey, JobDetail job, String triggerName, String triggerGroup, boolean addJob) throws SchedulerException {
        try {
            SimpleTrigger newTrigger = (SimpleTrigger)this.getComponent(triggerKey, SimpleTrigger.class);
            String baseName = null;
            baseName = triggerName != null ? triggerName : newTrigger.getName() + "-" + job.getName();
            newTrigger.setName(baseName + "-" + System.currentTimeMillis());
            if (triggerGroup != null) {
                newTrigger.setGroup(triggerGroup);
            }
            Trigger existingTrigger = this.scheduler.getTrigger(newTrigger.getName(), newTrigger.getGroup());
            while (existingTrigger != null) {
                newTrigger.setName(baseName + "-" + System.currentTimeMillis());
                existingTrigger = this.scheduler.getTrigger(newTrigger.getName(), newTrigger.getGroup());
            }
            newTrigger.setJobName(job.getName());
            newTrigger.setJobGroup(job.getGroup());
            if (newTrigger instanceof InitializingBean) {
                ((InitializingBean)newTrigger).afterPropertiesSet();
            }
            if (addJob) {
                this.scheduler.addJob(job, true);
            }
            return newTrigger;
        }
        catch (Exception e) {
            InvalidConfigurationException e2 = new InvalidConfigurationException("Unable to get a SimpleTrigger for job", e);
            throw new SchedulerException("Unable to trigger task immediately", (Exception)e2);
        }
    }

    @Override
    public void pauseJob(String jobName, String jobGroup) throws SchedulerException {
        this.scheduler.pauseJob(jobName, jobGroup);
    }

    @Override
    public void pauseAllJobs() throws SchedulerException {
        this.scheduler.pauseAll();
    }

    @Override
    public void resumeJob(String jobName, String jobGroup) throws SchedulerException {
        this.scheduler.resumeJob(jobName, jobGroup);
    }

    @Override
    public void resumeAllJobs() throws SchedulerException {
        this.scheduler.resumeAll();
    }

    @Override
    public void pauseTriggerGroup(String triggerGroup) throws SchedulerException {
        this.scheduler.pauseTriggerGroup(triggerGroup);
    }

    @Override
    public void resumeTriggerGroup(String triggerGroup) throws SchedulerException {
        this.scheduler.resumeTriggerGroup(triggerGroup);
    }
}

