/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobPersistenceException;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;

public class PersistentJobStore
extends LocalDataSourceJobStore {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public PersistentJobStore() {
        super.setLockOnInsert(false);
    }

    protected void rollbackConnection(Connection conn) throws JobPersistenceException {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                this.logger.error((Object)("Couldn't rollback jdbc connection. " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doRecoverMisfires() throws JobPersistenceException {
        Connection conn = null;
        try {
            conn = this.getNonManagedTXConnection();
            int currentMisfireCount = this.getDelegate().selectTriggersInState(conn, "MISFIRED").length;
            if (currentMisfireCount > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Misfire situation detected for " + currentMisfireCount + " triggers"));
                }
                boolean bl = super.doRecoverMisfires();
                return bl;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No Misfires detected for object: " + System.identityHashCode((Object)this)));
            }
        }
        catch (Exception e) {
            super.rollbackConnection(conn);
        }
        finally {
            super.closeConnection(conn);
        }
        return false;
    }
}

