/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.scheduling;

import gov.va.med.fw.scheduling.PersistentJobStore;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;

public class CustomSchedulerFactory
extends StdSchedulerFactory {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Class jobStoreClass = PersistentJobStore.class;
    private static Class SPRING_PERSISTENT_JOB_STORE = LocalDataSourceJobStore.class;

    public void initialize(Properties props) throws SchedulerException {
        if (this.jobStoreClass != null) {
            boolean replaced = false;
            String oldValue = (String)props.get("org.quartz.jobStore.class");
            if (SPRING_PERSISTENT_JOB_STORE.getName().equals(oldValue)) {
                if (SPRING_PERSISTENT_JOB_STORE.isAssignableFrom(this.jobStoreClass)) {
                    replaced = true;
                    props.put("org.quartz.jobStore.class", this.jobStoreClass.getName());
                }
            } else if (!SPRING_PERSISTENT_JOB_STORE.isAssignableFrom(this.jobStoreClass)) {
                replaced = true;
                props.put("org.quartz.jobStore.class", this.jobStoreClass.getName());
            }
            if (replaced && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("CustomSchedulerFactory overruled usage of JobStore [" + oldValue + "] in favor of more robust [" + this.jobStoreClass.getName() + "]"));
            }
        }
        super.initialize(props);
    }

    public Class getJobStoreClass() {
        return this.jobStoreClass;
    }

    public void setJobStoreClass(Class jobStoreClass) {
        this.jobStoreClass = jobStoreClass;
    }
}

