/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleMethod;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleRuleMethod
implements RuleMethod {
    private static final long serialVersionUID = 8020776505735217870L;
    protected Log logger = LogFactory.getLog(this.getClass());

    @Override
    public boolean isCalendarEqual(Calendar arg1, Calendar arg2, int field) throws RuleException {
        boolean compare = false;
        this.checkCalendarField(field, "Invalid calendar field");
        if (arg1 == arg2) {
            compare = true;
        } else if (arg1 != null && arg2 != null) {
            Calendar rounded1 = DateUtils.round((Calendar)arg1, (int)field);
            Calendar rounded2 = DateUtils.round((Calendar)arg2, (int)field);
            compare = rounded1.equals(rounded2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(" Arg1: " + (arg1 != null ? arg1.getTime() : null) + " Arg2: " + (arg2 != null ? arg2.getTime() : null)));
                this.logger.debug((Object)(" Returned value: " + compare));
            }
        }
        return compare;
    }

    @Override
    public boolean isEqual(Object arg1, Object arg2) {
        boolean compare = false;
        if (arg1 instanceof String && arg2 instanceof String && arg1 != null && arg2 != null) {
            compare = ((String)arg1).equalsIgnoreCase((String)arg2);
        } else if (arg1 != null && arg2 != null && Date.class.isAssignableFrom(arg1.getClass())) {
            Date lhsDate = (Date)arg1;
            Date rhsDate = (Date)arg2;
            compare = lhsDate.getTime() == rhsDate.getTime();
        } else {
            compare = ObjectUtils.equals((Object)arg1, (Object)arg2);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Arg1: " + (arg1 != null ? arg1.toString() : null) + " Arg2: " + (arg2 != null ? arg2.toString() : null)));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isNull(Object obj) {
        this.logger.debug((Object)("is null: " + (obj == null)));
        return obj == null;
    }

    @Override
    public BigDecimal add(BigDecimal a, BigDecimal b) {
        BigDecimal c = a.add(b).setScale(2, 4);
        this.logger.debug((Object)(a + " + " + b + " = " + c));
        return c;
    }

    @Override
    public BigDecimal percentageOf(BigDecimal a, double percentage) {
        BigDecimal percentDecimal = new BigDecimal(percentage / 100.0).setScale(2, 4);
        BigDecimal b = a.multiply(percentDecimal).setScale(2, 4);
        this.logger.debug((Object)(a + " * " + percentDecimal + " = " + b));
        return b;
    }

    @Override
    public boolean isEqual(BigDecimal arg1, int arg2) {
        boolean compare = this.isEqual(this.toInteger(arg1), new Integer(arg2));
        return compare;
    }

    @Override
    public boolean isInRange(Integer value, int lower, int upper) {
        boolean inRange = false;
        if (value != null) {
            boolean bl = inRange = lower <= value && value <= upper;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Lower bound: " + lower + " Upper bound: " + upper));
            this.logger.debug((Object)(" Returned value: " + inRange));
        }
        return inRange;
    }

    @Override
    public boolean isInRange(BigDecimal value, double lower, double upper) {
        boolean inRange = false;
        if (value != null) {
            boolean bl = inRange = lower <= value.doubleValue() && value.doubleValue() <= upper;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Lower bound: " + lower + " Upper bound: " + upper));
            this.logger.debug((Object)(" Returned value: " + inRange));
        }
        return inRange;
    }

    @Override
    public boolean isPartOf(String value, String pattern) {
        boolean compare = false;
        if (value != null && pattern != null) {
            boolean bl = compare = pattern.indexOf(value) != -1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" String to search " + value));
            this.logger.debug((Object)(" String to compare " + pattern));
        }
        return compare;
    }

    @Override
    public boolean isEmpty(Collection collection) {
        boolean empty = true;
        if (collection != null) {
            empty = collection.isEmpty();
        }
        return empty;
    }

    @Override
    public boolean isLessThan(Integer value, int upper) {
        boolean compare = false;
        if (value != null) {
            boolean bl = compare = value < upper;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Upper bound: " + upper));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isGreaterThan(Integer value, int lower) {
        boolean compare = false;
        if (value != null) {
            boolean bl = compare = value > lower;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Lower bound: " + lower));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isGreaterThan(BigDecimal value, BigDecimal lower) {
        boolean compare = false;
        if (value != null && lower != null) {
            boolean bl = compare = value.compareTo(lower) == 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" value: " + value));
            this.logger.debug((Object)(" Lower bound: " + lower));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isGreaterThan(BigDecimal value, Integer lower) {
        boolean compare = false;
        if (value != null && lower != null) {
            BigDecimal lowerBD = new BigDecimal(lower);
            boolean bl = compare = value.compareTo(lowerBD) == 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" value: " + value));
            this.logger.debug((Object)(" Lower bound: " + lower));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isGreaterThan(Integer value, BigDecimal lower) {
        boolean compare = false;
        if (value != null && lower != null) {
            BigDecimal valueBD = new BigDecimal(value);
            boolean bl = compare = valueBD.compareTo(lower) == 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" value: " + value));
            this.logger.debug((Object)(" Lower bound: " + lower));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isGreaterThan(Integer value, Integer lower) {
        boolean compare = false;
        if (value != null && lower != null) {
            int lowerInt = lower;
            boolean bl = compare = value > lowerInt;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Lower bound: " + lower));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isLessThan(BigDecimal value, BigDecimal upper) {
        boolean compare = false;
        if (value != null && upper != null) {
            boolean bl = compare = value.compareTo(upper) == -1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" value: " + value));
            this.logger.debug((Object)(" Upper bound: " + upper));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isDateBetween(Date dateToCheck, Date lowerDate, Date upperDate) {
        long upperTime;
        long lowTime;
        if (dateToCheck == null) {
            return false;
        }
        long checkTime = dateToCheck.getTime();
        if (lowerDate != null && checkTime < (lowTime = lowerDate.getTime())) {
            return false;
        }
        return upperDate == null || checkTime <= (upperTime = upperDate.getTime());
    }

    @Override
    public boolean isSameDay(Date value1, Date value2) {
        if (value1 != null && value2 != null) {
            return DateUtils.isSameDay((Date)value1, (Date)value2);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Value 1: " + value1));
            this.logger.debug((Object)(" Value 2: " + value2));
        }
        return false;
    }

    @Override
    public boolean isBefore(Date value, Date upper) {
        boolean compare = false;
        if (value != null && upper != null) {
            boolean bl = compare = value.before(upper);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Upper bound: " + upper));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public boolean isAfter(Date value, Date lower) {
        boolean compare = false;
        if (value != null && lower != null) {
            boolean bl = compare = value.after(lower);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Upper bound: " + lower));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    @Override
    public Date toDate(String value) throws ParseException {
        Validate.notNull((Object)value, (String)"A date string must not be NULL");
        Date parsed = this.toDate(value, 3);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Input date string: " + value));
            this.logger.debug((Object)(" Parsed date: " + parsed));
        }
        return parsed;
    }

    @Override
    public Date toDate(String value, int pattern) throws ParseException {
        Validate.notNull((Object)value, (String)"A date string must not be NULL");
        Date parsed = SimpleDateFormat.getDateInstance(pattern).parse(value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Input date string: " + value));
            this.logger.debug((Object)(" Parsed date: " + parsed));
        }
        return parsed;
    }

    @Override
    public Date getCurrentDate() {
        Date current = Calendar.getInstance().getTime();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" The current date: " + current));
        }
        return current;
    }

    @Override
    public String getLoggedInUser() {
        SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
        return securityContext != null ? securityContext.getUserName() : null;
    }

    @Override
    public int getSize(Collection collection) {
        return collection == null ? 0 : collection.size();
    }

    @Override
    public Calendar toCalendar(Date date, TimeZone timezone) {
        Validate.notNull((Object)date, (String)"A date object must not be NULL");
        Calendar calendar = Calendar.getInstance();
        if (timezone == null) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        } else {
            calendar.setTimeZone(timezone);
        }
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    @Override
    public Calendar toCalendar(Date date) {
        return this.toCalendar(date, null);
    }

    @Override
    public Integer toInteger(Number value) {
        int converted = value != null ? value.intValue() : 0;
        return this.toInteger(converted);
    }

    @Override
    public Integer toInteger(int value) {
        Integer converted = new Integer(value);
        return converted;
    }

    protected void checkCalendarField(int field, String message) throws RuleException {
        if (field != 13 && field != 12 && field != 10 && field != 5 && field != 2 && field != 1) {
            throw new RuleException(message);
        }
    }
}

