/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.model.lookup.SeverityType;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleFlowNameAware;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleValidationException;
import gov.va.med.fw.validation.ValidationFieldMessage;
import gov.va.med.fw.validation.ValidationMessages;
import java.io.Serializable;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RuleState
implements Serializable {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final long serialVersionUID = -4973518623152819174L;
    private RuleFlowNameAware ruleFlowNameAware = null;
    private RuleParameter ruleParameter = null;
    public static final String DEFAULT_PARAM_NAME = StringUtils.uncapitalize((String)ClassUtils.getShortClassName(RuleState.class));
    private boolean executed = false;
    private String name = DEFAULT_PARAM_NAME;
    private boolean inSession = false;
    private boolean exhaustiveMode = false;
    private ValidationMessages validationMessages = new ValidationMessages();

    public void setRuleExecuted(boolean flag) {
        this.logger.debug((Object)("" + flag));
        this.executed = flag;
    }

    public void setInSession(boolean flag) {
        this.inSession = flag;
    }

    public boolean isRuleExecuted() {
        return this.executed;
    }

    public boolean isInSession() {
        return this.inSession;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void generateRuleException(String id, String originator) throws RuleException {
        this.generateRuleException(id, originator, SeverityType.ERROR, null);
    }

    public void generateRuleException(String id, String originator, SeverityType severity) throws RuleException {
        this.generateRuleException(id, originator, severity, null);
    }

    public void generateRuleException(String id, String originator, SeverityType severity, Object contextInfo) throws RuleException {
        this.generateRuleException(id, originator, severity, null, true);
    }

    public void generateRuleException(String id, String originator, SeverityType severity, Object contextInfo, boolean createWkList) throws RuleException {
        if (!this.isExhaustiveMode() && SeverityType.ERROR.getCode().equals(severity.getCode())) {
            RuleValidationException e = new RuleValidationException(id, originator, this.getRuleFlowNameAware().getRuleFlowName(), this.getRuleParameter());
            e.setSeverityType(severity);
            e.setContextInfo(contextInfo);
            e.setCreateWkList(createWkList);
            throw e;
        }
        ValidationFieldMessage msg = new ValidationFieldMessage(originator, id, severity);
        msg.setContextInfo(contextInfo);
        msg.setCreateWkList(createWkList);
        this.validationMessages.add(msg);
    }

    public RuleFlowNameAware getRuleFlowNameAware() {
        return this.ruleFlowNameAware;
    }

    public RuleParameter getRuleParameter() {
        return this.ruleParameter;
    }

    public void setRuleFlowNameAware(RuleFlowNameAware ruleFlow) {
        this.ruleFlowNameAware = ruleFlow;
    }

    public void setRuleParameter(RuleParameter ruleParam) {
        this.ruleParameter = ruleParam;
    }

    public boolean isExhaustiveMode() {
        return this.exhaustiveMode;
    }

    public void setExhaustiveMode(boolean exhaustiveMode) {
        this.exhaustiveMode = exhaustiveMode;
    }

    public ValidationMessages getValidationMessages() {
        return this.validationMessages;
    }
}

