/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.rule.RuleConfigurationException;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleFlow;
import gov.va.med.fw.rule.RuleFlowManager;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class RuleFlowService
extends AbstractComponent
implements RuleFlow {
    private RuleFlowManager ruleManager = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.ruleManager == null) {
            throw new RuleConfigurationException("A rule manager must be configured for this service");
        }
    }

    public RuleFlowManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(RuleFlowManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    @Override
    public Object execute(RuleParameters params, RuleDataAware ruleData) throws RuleException {
        Validate.notNull((Object)params, (String)"Rule parameters must not be null");
        Validate.notNull((Object)ruleData, (String)"A rule data must not be null");
        params.initializeRuleParmeters(ruleData);
        return this.ruleManager.fireRule(params.getRuleFlowName(), params);
    }

    @Override
    public Object execute(RuleParameters params, Map ruleData) throws RuleException {
        Validate.notNull((Object)params, (String)"Rule parameters must not be null");
        Validate.notEmpty((Map)ruleData, (String)"Rule data map must not be null or empty");
        params.initializeRuleParmeters(ruleData);
        return this.ruleManager.fireRule(params.getRuleFlowName(), params);
    }

    @Override
    public Object execute(RuleParameter param, RuleDataAware data) throws RuleException {
        Validate.notNull((Object)param, (String)"A rule parameter must not be null");
        Validate.notNull((Object)data, (String)"A rule data must not be null");
        param.setIncomingData(data.getIncomingData());
        param.setPristineData(data.getPristineData());
        param.setResultData(data.getResultData());
        param.setRuleDataAware(data);
        return this.ruleManager.fireRule(param.getRuleFlowName(), param);
    }
}

