/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.rule;

import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.rule.RuleFlow;
import gov.va.med.fw.rule.RuleParameter;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.rule.RuleState;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class AbstractRuleFlowAwareService
extends AbstractComponent {
    private RuleFlow ruleFlow = null;

    protected AbstractRuleFlowAwareService() {
    }

    public RuleFlow getRuleFlow() {
        return this.ruleFlow;
    }

    public void setRuleFlow(RuleFlow ruleFlow) {
        this.ruleFlow = ruleFlow;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.ruleFlow, (String)"A rule flow service must not be null");
    }

    protected ValidationMessages invokeRuleFlow(RuleParameters parameters, RuleDataAware ruleData) throws ServiceException {
        return this.invokeRuleFlow(parameters, ruleData, "ELIMINATION");
    }

    protected ValidationMessages invokeRuleFlow(RuleParameters parameters, RuleDataAware ruleData, String validationMode) throws ServiceException {
        ValidationMessages messages = null;
        try {
            this.setExhaustiveMode(parameters, "EXHAUSTIVE".equals(validationMode));
            this.getRuleFlow().execute(parameters, ruleData);
            RuleState ruleState = parameters.getState();
            if (ruleState != null && ruleState.isExhaustiveMode()) {
                messages = ruleState.getValidationMessages();
            }
        }
        catch (RuleException e) {
            throw new ServiceException("Failed to invoke rule flow " + parameters.getRuleFlowName(), e);
        }
        return messages;
    }

    protected void invokeRuleFlow(RuleParameters parameters, Map ruleData) throws ServiceException {
        try {
            this.getRuleFlow().execute(parameters, ruleData);
        }
        catch (RuleException e) {
            throw new ServiceException("Failed to invoke rule flow " + parameters.getRuleFlowName(), e);
        }
    }

    protected RuleParameters getRuleParameters(String name) throws NoSuchBeanDefinitionException {
        try {
            return (RuleParameters)this.getComponent(name, RuleParameters.class);
        }
        catch (ServiceException e) {
            throw new NoSuchBeanDefinitionException("Failed to obtain rule parameters: " + name);
        }
    }

    protected void setExhaustiveMode(RuleParameters parameters, boolean flag) {
        Collection params = parameters.getRuleParameters().values();
        for (RuleParameter param : params) {
            param.getState().setExhaustiveMode(flag);
        }
        parameters.getState().setExhaustiveMode(flag);
    }
}

