/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.report.data.hibernate;

import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.PostProcessedList;
import gov.va.med.fw.report.data.ReportDataDAO;
import gov.va.med.fw.report.data.ReportDataException;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public abstract class HibernateReportDataDAO
extends AbstractDAOImpl
implements ReportDataDAO {
    private static final long serialVersionUID = 2573263207581367146L;
    private String queryName = null;
    private int fetchSize = 100;
    private boolean cacheable = true;
    private boolean paginated = true;
    private boolean postProcessRequired = true;

    protected HibernateReportDataDAO() {
    }

    @Override
    protected void initDao() throws Exception {
        super.initDao();
        Validate.notNull((Object)this.queryName, (String)"A hibernate quey name must be configured");
    }

    public boolean isPostProcessRequired() {
        return this.postProcessRequired;
    }

    public void setPostProcessRequired(boolean postProcessRequired) {
        this.postProcessRequired = postProcessRequired;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public void setPaginated(boolean paginated) {
        this.paginated = paginated;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isPaginated() {
        return this.paginated;
    }

    @Override
    public List getRecords(final ReportConfiguration config, final int firstRecord, final int maxRecord) throws ReportDataException {
        Validate.notNull((Object)config, (String)"A report configuration must not be NULL");
        Validate.notNull((Object)config.getQueryCriteria(), (String)"A report criteria must not be NULL");
        HibernateCallback callback = new HibernateCallback(){

            public Object doInHibernate(Session session) {
                List results = null;
                try {
                    results = HibernateReportDataDAO.this.buildQuery(config, session).setCacheable(HibernateReportDataDAO.this.isCacheable()).setFirstResult(firstRecord).setMaxResults(HibernateReportDataDAO.this.isPaginated() ? maxRecord : Integer.MAX_VALUE).setFetchSize(maxRecord > HibernateReportDataDAO.this.getFetchSize() ? maxRecord : HibernateReportDataDAO.this.getFetchSize()).list();
                }
                catch (ReportDataException e) {
                    throw new HibernateException("Failed to retrieve a result set in a report dao", (Throwable)e);
                }
                return results;
            }
        };
        List results = null;
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            results = tpl.executeFind(callback);
            if (!results.isEmpty() && this.isPostProcessRequired()) {
                results = new PostProcessedList(this.postDataRetrieval(results, config), results);
            }
        }
        catch (DataAccessException e) {
            throw new ReportDataException("Failed to execute a query to retrieve report data", e);
        }
        return results;
    }

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
    }

    @Override
    public List postDataRetrieval(List results, ReportConfiguration config) throws ReportDataException {
        return results;
    }

    protected String getQueryName() {
        return this.queryName;
    }

    protected Query getNamedQuery(Session session) {
        return this.getNamedQuery(this.queryName, session);
    }

    protected Query getNamedQuery(String name, Session session) {
        return session != null ? session.getNamedQuery(name) : null;
    }

    protected abstract Query buildQuery(ReportConfiguration var1, Session var2) throws ReportDataException;
}

