/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.persistent.hibernate;

import gov.va.med.fw.persistent.QueryIncrementTracker;
import gov.va.med.fw.persistent.QueryInfo;
import gov.va.med.fw.persistent.QueryResults;
import gov.va.med.fw.persistent.ScrollableCallback;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;

public class ScrollableDAOAction
extends AbstractDAOAction {
    private ScrollableCallback handler;
    private QueryInfo query;
    private QueryIncrementTracker tracker;

    protected ScrollableDAOAction(ScrollableCallback handler, QueryInfo query, QueryIncrementTracker tracker) {
        this.handler = handler;
        this.query = query;
        this.tracker = tracker != null ? tracker : new QueryResults();
    }

    protected ScrollableDAOAction(ScrollableCallback handler, QueryInfo query) {
        this(handler, query, null);
    }

    @Override
    protected Object execute(Session session) {
        Query queryImpl = this.query.isNamedQuery() ? session.getNamedQuery(this.query.getQuery()) : session.createQuery(this.query.getQuery());
        queryImpl.setFetchSize(this.query.getFetchSize());
        String[] paramNames = this.query.getParamNames();
        Object[] paramValues = this.query.getParamValues();
        if (paramNames != null && paramValues != null) {
            Validate.isTrue((paramNames.length == paramValues.length ? 1 : 0) != 0, (String)"ParamNames and paramValues array must be of same size.");
            for (int i = 0; i < paramNames.length; ++i) {
                queryImpl.setParameter(paramNames[i], paramValues[i]);
            }
        }
        ScrollableResults results = queryImpl.scroll(ScrollMode.FORWARD_ONLY);
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        int total = 0;
        int scrollCheckSize = 5 * this.query.getFetchSize();
        while (results.next()) {
            ++total;
            data.add(results.get());
            if (data.size() != scrollCheckSize) continue;
            if (!this.handler.continueScrolling(this.tracker)) break;
            this.callback(data, total);
            data.clear();
        }
        if (!data.isEmpty()) {
            this.callback(data, total);
        }
        return new Integer(total);
    }

    private void callback(List data, int count) {
        this.tracker.setIncrementalData(data);
        this.tracker.setCurrentRecord(count);
        this.handler.handleScrolledData(this.tracker);
    }

    public ScrollableCallback getHandler() {
        return this.handler;
    }

    public void setHandler(ScrollableCallback handler) {
        this.handler = handler;
    }

    public QueryInfo getQuery() {
        return this.query;
    }

    public void setQuery(QueryInfo query) {
        this.query = query;
    }
}

