/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.model;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.UserPrincipal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RolePrincipalImpl
extends AbstractKeyedEntity
implements RolePrincipal {
    private static final long serialVersionUID = 2691128619281850078L;
    private String name = null;
    private String description = null;
    private Set internalUsers = null;

    public RolePrincipalImpl() {
    }

    public RolePrincipalImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private Set getInternalUsers() {
        if (this.internalUsers == null) {
            this.internalUsers = new HashSet();
        }
        return this.internalUsers;
    }

    private void setInternalUsers(Set internalUsers) {
        this.internalUsers = internalUsers;
    }

    @Override
    public Set getRoleUsers() {
        return Collections.unmodifiableSet(this.getInternalUsers());
    }

    public void addRoleUser(UserPrincipal userPrincipal) {
        Validate.notNull((Object)userPrincipal, (String)"Can not add null UserPrincipal");
        this.getInternalUsers().add(userPrincipal);
    }

    public void removeRoleUser(UserPrincipal userPrincipal) {
        Validate.notNull((Object)userPrincipal, (String)"Can not remove null UserPrincipal");
        this.getInternalUsers().remove(userPrincipal);
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("name", (Object)this.name);
        builder.append("description", (Object)this.description);
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof RolePrincipal && this.equals((RolePrincipal)o);
    }

    protected boolean equals(RolePrincipal rolePrincipal) {
        return rolePrincipal != null && this.getName() != null && rolePrincipal.getName() != null && this.getName().equals(rolePrincipal.getName());
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.setInternalUsers(null);
    }
}

