/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.model;

import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.model.VersionedEntityKey;
import gov.va.med.fw.model.lookup.ModelPropertiesApplicationType;
import gov.va.med.fw.util.Reflector;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class AbstractKeyedEntity
extends AbstractVersionedEntity {
    private static final long serialVersionUID = -7858974447945480434L;
    private Serializable identifier = null;

    protected AbstractKeyedEntity() {
    }

    protected AbstractKeyedEntity(EntityKey identifier) {
        this.identifier = identifier;
    }

    protected AbstractKeyedEntity(EntityKey identifier, Date createdOn, Date modifiedOn, Integer version) {
        super(createdOn, modifiedOn, version);
        this.identifier = identifier;
    }

    public EntityKey getEntityKey() {
        EntityKey key = null;
        if (this.identifier != null) {
            try {
                if (this.getEntityKeyClass() == null) {
                    key = EntityKeyFactory.createEntityKey(this.identifier, this.getVersion(), this.getClass());
                } else {
                    if (!EntityKey.class.isAssignableFrom(this.getEntityKeyClass())) {
                        throw new IllegalArgumentException("Subclass defined getEntityKeyClass() is not assignable from EntityKey");
                    }
                    Object[] args = new Object[]{this.identifier};
                    if (VersionedEntityKey.class.isAssignableFrom(this.getEntityKeyClass()) && this.getVersion() != null) {
                        args = new Object[]{this.identifier, this.getVersion()};
                    }
                    key = (EntityKey)Reflector.instantiate(this.getEntityKeyClass(), args);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create EntityKey(identifier, Class) for AbstractKeyedEntity");
            }
        }
        return key;
    }

    public static AbstractKeyedEntity getEntityByEntityKey(Collection collection, EntityKey identifier) {
        if (collection != null) {
            for (Object object : collection) {
                AbstractKeyedEntity keyedEntity;
                EntityKey entityKey;
                if (!(object instanceof AbstractKeyedEntity) || !identifier.equals(entityKey = (keyedEntity = (AbstractKeyedEntity)object).getEntityKey())) continue;
                return keyedEntity;
            }
        }
        return null;
    }

    public static AbstractKeyedEntity removeEntityByEntityKey(Collection collection, EntityKey identifier) {
        AbstractKeyedEntity keyedEntity = AbstractKeyedEntity.getEntityByEntityKey(collection, identifier);
        if (keyedEntity != null) {
            collection.remove(keyedEntity);
        }
        return keyedEntity;
    }

    protected Class getEntityKeyClass() {
        return null;
    }

    protected Serializable getIdentifier() {
        return this.identifier;
    }

    protected void setIdentifier(Serializable identifier) {
        this.identifier = identifier;
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        this.identifier = null;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        if (this.identifier == null) {
            hashCode = this.noIdentifierHashCode();
        } else {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append(this.getClass());
            builder.append((Object)this.identifier);
            hashCode = builder.toHashCode();
        }
        return hashCode;
    }

    private int noIdentifierHashCode() {
        return super.hashCode();
    }

    @Override
    public final boolean isModelPropertiesEqual(Object o, String modelPropertiesApplication) {
        if (ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName().equals(modelPropertiesApplication) && o instanceof AbstractKeyedEntity) {
            EntityKey yourKey;
            EntityKey myKey = this.getEntityKey();
            EntityKey entityKey = yourKey = o != null ? ((AbstractKeyedEntity)o).getEntityKey() : null;
            if (myKey != null && yourKey != null) {
                EqualsBuilder builder = new EqualsBuilder();
                builder.append((Object)myKey, (Object)yourKey);
                return builder.isEquals();
            }
        }
        return super.isModelPropertiesEqual(o, modelPropertiesApplication);
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        builder.append("identifier", (Object)this.identifier);
        super.buildToString(builder);
    }

    protected void validateOwner(AbstractKeyedEntity existingOwner, AbstractKeyedEntity newOwner) {
        if (existingOwner != null && newOwner != null && existingOwner != newOwner) {
            String msg = "Object is already assigned to another owner [" + existingOwner.getClass().getName() + " Id=" + existingOwner.getIdentifier() + "]";
            throw new IllegalArgumentException(msg);
        }
    }
}

