/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io.writer;

import gov.va.med.fw.io.FieldTransformer;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.DateUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateFieldTransformer
extends AbstractComponent
implements FieldTransformer {
    private static final String DEFAULT_DATE_FORMAT = "yyyyMMdd";
    private static final String CENTURY_FORMAT = "CyyMMdd";
    private static final String CENTURY_1800 = "1";
    private static final String CENTURY_1900 = "2";
    private static final String CENTURY_2000 = "3";
    private String dateFormat;

    @Override
    public Object transformData(String fieldName, Object data) throws Exception {
        if (data == null) {
            return null;
        }
        if (!(data instanceof Date)) {
            throw new IllegalArgumentException("Invalid Date passed as argument " + data);
        }
        String formattedDate = null;
        formattedDate = CENTURY_FORMAT.equals(this.dateFormat) ? this.getCenturyFormattedDate((Date)data) : new SimpleDateFormat(this.dateFormat).format((Date)data);
        return formattedDate;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.dateFormat == null) {
            this.dateFormat = DEFAULT_DATE_FORMAT;
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    private String getCenturyFormattedDate(Date date) {
        Calendar cal = DateUtils.createCalendar(date);
        String century = null;
        if (cal.get(1) >= 1800 && cal.get(1) < 1900) {
            century = CENTURY_1800;
        } else if (cal.get(1) >= 1900 && cal.get(1) < 2000) {
            century = CENTURY_1900;
        } else if (cal.get(1) > 2000) {
            century = CENTURY_2000;
        }
        return century + new SimpleDateFormat(CENTURY_FORMAT.substring(1)).format(date);
    }
}

