/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io.parser;

import com.infomata.data.DataFile;
import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.DelimitedFormat;
import gov.va.med.fw.io.FileFieldMetaData;
import gov.va.med.fw.io.FixedWidthFormat;
import gov.va.med.fw.io.RawFileDataContainer;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.io.SimpleDelimiterFormat;
import gov.va.med.fw.io.parser.AbstractFileParserBuilder;
import gov.va.med.fw.io.parser.InputDataFormat;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.InvalidConfigurationException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.ListOrderedMap;
import org.springframework.core.io.FileSystemResource;

public class FormattedFileParserBuilder
extends AbstractFileParserBuilder {
    private static final long serialVersionUID = 6896484962490107620L;
    private static String DEFAULT_DELIMITER = "^";
    private Map classMappings = new HashMap();
    private String delimiter;
    private InputDataFormat inputDataFormat;
    private ClassMapping classMapping;
    private boolean failOnUnmappedData = true;

    @Override
    public final synchronized List build(DataFileProcessExecutionContext context, FileSystemResource fileSystemResource) throws BuilderException {
        ArrayList<Object> data = new ArrayList<Object>();
        ArrayList<Object> listenerData = null;
        if (context.hasFileParserListener()) {
            listenerData = new ArrayList<Object>();
        }
        DataFile reader = DataFile.createReader(null);
        Object instance = null;
        reader.setDataFormat((DataFormat)this.inputDataFormat);
        String currentRowRawData = null;
        String nextRowRawData = null;
        try {
            reader.open(fileSystemResource.getFile());
            DataRow row = null;
            DataRow nextRow = null;
            ClassMapping currentClassMapping = this.classMapping;
            boolean isUsingSectionHeaders = false;
            while (this.shouldContinueParsing(context)) {
                block29: {
                    try {
                        if (nextRow != null) {
                            row = nextRow;
                            currentRowRawData = nextRowRawData;
                            context.setCurrentRowRawData(currentRowRawData);
                            nextRowRawData = null;
                            nextRow = null;
                        } else {
                            row = reader.next();
                            currentRowRawData = this.inputDataFormat.getInputRawData();
                            context.setCurrentRowRawData(currentRowRawData);
                        }
                        if (row == null) break;
                        instance = null;
                        if (row.size() == 0) break block29;
                        String val = (String)row.iterator().next();
                        ClassMapping targetClassMapping = (ClassMapping)((Object)this.classMappings.get(val));
                        if (targetClassMapping != null) {
                            isUsingSectionHeaders = true;
                            currentClassMapping = targetClassMapping;
                            if (targetClassMapping.isSectionHeaderOnSeparateLine()) {
                                row = reader.next();
                                currentRowRawData = this.inputDataFormat.getInputRawData();
                                context.setCurrentRowRawData(currentRowRawData);
                                if (row == null) {
                                    throw new IllegalStateException("Missing data row in file on line below section header: " + val);
                                }
                                if (row.size() == 0) {
                                    throw new IllegalStateException("Blank line not allowed below section header: " + val);
                                }
                            } else {
                                boolean keepPeeking = true;
                                while (keepPeeking) {
                                    keepPeeking = false;
                                    nextRow = reader.next();
                                    if (nextRow == null || nextRow.size() == 0) continue;
                                    String nextRowFirstVal = (String)nextRow.iterator().next();
                                    if (!this.classMappings.containsKey(nextRowFirstVal)) {
                                        String combinedData = currentRowRawData + this.inputDataFormat.getInputRawData();
                                        row = this.inputDataFormat.parseLine(combinedData);
                                        nextRow = null;
                                        currentRowRawData = combinedData;
                                        context.setCurrentRowRawData(combinedData);
                                        keepPeeking = true;
                                        continue;
                                    }
                                    nextRowRawData = this.inputDataFormat.getInputRawData();
                                }
                            }
                        }
                        if (currentClassMapping == null) {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn((Object)("Unable to parse input data for row: " + this.decorateRowRawData(currentRowRawData)));
                            }
                            if (this.failOnUnmappedData) {
                                throw new IllegalStateException("Unable to determine ClassMapping for row with first value: " + val);
                            }
                        }
                        instance = this.populateBean(currentClassMapping, row, isUsingSectionHeaders, currentRowRawData);
                        if (context.hasFileParserListener()) {
                            if (nextRow == null) {
                                nextRow = reader.next();
                                nextRowRawData = this.inputDataFormat.getInputRawData();
                            }
                            context.getFileParserListener().beanCreationSuccess(context, nextRowRawData);
                        }
                        if (!this.logger.isDebugEnabled()) break block29;
                        this.logger.debug((Object)("FormattedFileParserBuilder populated object : " + instance));
                    }
                    catch (Exception e) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error((Object)("Unable to create bean instance for line: " + this.decorateRowRawData(currentRowRawData)), (Throwable)e);
                        }
                        if (!context.hasFileParserListener()) continue;
                        if (nextRow == null) {
                            nextRow = reader.next();
                            nextRowRawData = this.inputDataFormat.getInputRawData();
                        }
                        if (context.getFileParserListener().beanCreationFailure(context, nextRowRawData, e)) continue;
                        listenerData.clear();
                        continue;
                    }
                }
                if (context.hasFileParserListener()) {
                    if (nextRow == null) {
                        nextRow = reader.next();
                        nextRowRawData = this.inputDataFormat.getInputRawData();
                    }
                    if (instance != null) {
                        listenerData.add(instance);
                    }
                    if (!context.getFileParserListener().acceptData(context, nextRowRawData, listenerData)) continue;
                    context.getFileParserListener().processData(context, listenerData);
                    listenerData.clear();
                    continue;
                }
                if (instance == null) continue;
                data.add(instance);
            }
            if (context.hasFileParserListener() && !listenerData.isEmpty()) {
                context.getFileParserListener().processData(context, listenerData);
            }
        }
        catch (Exception e) {
            throw new BuilderException("Unable to parse the file " + fileSystemResource.getFilename(), e);
        }
        finally {
            reader.close();
        }
        return data;
    }

    private String decorateRowRawData(String rowRawData) {
        String decorated = rowRawData;
        if (this.inputDataFormat instanceof DelimitedFormat) {
            StringBuffer buf = new StringBuffer();
            String delimiter = ((DelimitedFormat)((Object)this.inputDataFormat)).getDelimiter();
            String[] elements = rowRawData.split("\\" + delimiter);
            for (int i = 0; i < elements.length; ++i) {
                if (i == 0) {
                    buf.append(elements[i]);
                } else {
                    buf.append("{").append(i).append("}").append(elements[i]);
                }
                buf.append(delimiter);
            }
            decorated = buf.toString();
        }
        return decorated;
    }

    protected boolean shouldContinueParsing(DataFileProcessExecutionContext context) {
        boolean shouldContinue = true;
        if (context.hasFileParserListener()) {
            shouldContinue = !context.getFileParserListener().isInterrupted(context);
        }
        return shouldContinue;
    }

    protected Object populateBean(ClassMapping classMapping, DataRow dataRow, boolean isUsingSectionHeaders, String currentRowRawData) throws Exception {
        Iterator itr = dataRow.iterator();
        String val = null;
        int index = 0;
        FileFieldMetaData metaData = null;
        ListOrderedMap data = new ListOrderedMap();
        boolean firstValue = true;
        Object transformedVal = null;
        while (itr.hasNext()) {
            transformedVal = null;
            val = (String)itr.next();
            if (isUsingSectionHeaders && firstValue && !classMapping.isSectionHeaderOnSeparateLine()) {
                firstValue = false;
                continue;
            }
            firstValue = false;
            if (!classMapping.hasFieldsMetaData()) break;
            if (classMapping.isExplicitFieldsMetaDataOrdering()) {
                metaData = classMapping.getFieldMetaData(Integer.toString(index));
            } else if (classMapping.getFieldsMetaData().size() > index) {
                metaData = (FileFieldMetaData)((Object)classMapping.getFieldsMetaData().get(index));
            }
            if (metaData != null) {
                if (StringUtils.isNotBlank((String)(val = metaData.validate(val)))) {
                    transformedVal = metaData.transform(val);
                    if (transformedVal != null) {
                        data.put((Object)metaData.getName(), transformedVal);
                    } else {
                        data.put((Object)metaData.getName(), (Object)val);
                    }
                } else {
                    data.put((Object)metaData.getName(), (Object)val);
                }
            } else {
                data.put((Object)Integer.toString(index), (Object)val);
            }
            ++index;
        }
        Object instance = classMapping.getTargetClass().newInstance();
        RawFileDataContainerUtils.autoRegisterConvertersForClass(instance.getClass());
        if (instance instanceof RawFileDataContainer) {
            RawFileDataContainerUtils.autoRegisterConvertersForClasses(((RawFileDataContainer)instance).getClassesForAutoRegisterConverters());
            if (!data.isEmpty()) {
                DataRow newDataRow = new DataRow();
                MapIterator itr2 = data.mapIterator();
                while (itr2.hasNext()) {
                    itr2.next();
                    newDataRow.add(itr2.getValue());
                }
                dataRow = newDataRow;
            }
            ((RawFileDataContainer)instance).setRawFileData(currentRowRawData, dataRow, classMapping);
        } else if (!data.isEmpty()) {
            BeanUtils.copyProperties(instance, (Object)data);
        }
        return instance;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.classMapping == null && this.classMappings.isEmpty()) {
            throw new InvalidConfigurationException("Must have at least one ClassMapping instance");
        }
        if (this.classMapping != null && !this.classMappings.isEmpty()) {
            throw new InvalidConfigurationException("For multiple ClassMapping's, configure only the classMappings property");
        }
        int[] fieldWidths = null;
        boolean isFixedFieldFormatter = false;
        Iterator itr = null;
        FileFieldMetaData metaData2 = null;
        Class type = null;
        Object instance = null;
        if (this.classMapping != null && this.classMapping.hasFieldsMetaData()) {
            itr = this.classMapping.getFieldsMetaData().iterator();
            instance = this.classMapping.getTargetClass().newInstance();
            fieldWidths = new int[this.classMapping.getFieldsMetaData().size()];
            int i = 0;
            while (itr.hasNext()) {
                metaData2 = (FileFieldMetaData)((Object)itr.next());
                if (metaData2.getFixedFieldWidth() != 0) {
                    isFixedFieldFormatter = true;
                }
                fieldWidths[i++] = metaData2.getFixedFieldWidth();
                type = PropertyUtils.getPropertyType(instance, (String)metaData2.getName());
                if (type == null || !Lookup.class.isAssignableFrom(type)) continue;
                ConvertUtils.register((Converter)this.getLookupConverter(), (Class)type);
            }
            instance = null;
        }
        if (this.classMappings != null) {
            Iterator classMappingsItr = this.classMappings.values().iterator();
            ClassMapping cm = null;
            while (classMappingsItr.hasNext()) {
                cm = (ClassMapping)((Object)classMappingsItr.next());
                if (!cm.hasFieldsMetaData()) continue;
                instance = cm.getTargetClass().newInstance();
                for (FileFieldMetaData metaData2 : cm.getFieldsMetaData()) {
                    type = PropertyUtils.getPropertyType(instance, (String)metaData2.getName());
                    if (!Lookup.class.isAssignableFrom(type)) continue;
                    ConvertUtils.register((Converter)this.getLookupConverter(), (Class)type);
                }
            }
        }
        if (isFixedFieldFormatter) {
            this.inputDataFormat = new FixedWidthFormat(fieldWidths);
        } else if (!StringUtils.isEmpty((String)this.delimiter)) {
            this.inputDataFormat = new SimpleDelimiterFormat(this.delimiter);
        }
        if (this.inputDataFormat == null) {
            this.inputDataFormat = new SimpleDelimiterFormat(DEFAULT_DELIMITER);
        }
        if (isFixedFieldFormatter && this.classMappings.size() > 0) {
            throw new InvalidConfigurationException("Unable to use a uniform (ie, the same) FixedWidthFormat across varying classes");
        }
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public InputDataFormat getInputDataFormat() {
        return this.inputDataFormat;
    }

    public void setInputDataFormat(InputDataFormat inputDataFormat) {
        this.inputDataFormat = inputDataFormat;
    }

    public ClassMapping getClassMapping() {
        return this.classMapping;
    }

    public void setClassMapping(ClassMapping classMapping) {
        this.classMapping = classMapping;
    }

    public Map getClassMappings() {
        return this.classMappings;
    }

    public void setClassMappings(Map classMappings) {
        this.classMappings = classMappings;
    }

    public boolean isFailOnUnmappedData() {
        return this.failOnUnmappedData;
    }

    public void setFailOnUnmappedData(boolean failOnUnmappedData) {
        this.failOnUnmappedData = failOnUnmappedData;
    }
}

