/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.Lookup;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class RawFileDataContainerUtils {
    private static Converter lookupConverter;
    private static Map converters;
    private static Set lookupsToRegister;
    private static Map classLoaderToClassesAutoRegistered;

    public static void autoRegisterConvertersForClasses(Class[] classes) {
        if (classes != null) {
            for (int i = 0; i < classes.length; ++i) {
                RawFileDataContainerUtils.autoRegisterConvertersForClass(classes[i]);
            }
        }
    }

    public static void autoRegisterConvertersForClass() {
        StackTraceElement[] elements = new Exception().getStackTrace();
        String className = elements[1].getClassName();
        try {
            RawFileDataContainerUtils.autoRegisterConvertersForClass(Class.forName(className));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load class: " + className);
        }
    }

    public static void registerConverterForLookupClass(Class clazz) {
        if (!Lookup.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Can not register LookupConverter for class that is not assignable from Lookup.class");
        }
        if (lookupConverter == null && (lookupConverter = ConvertUtils.lookup(Lookup.class)) == null) {
            lookupsToRegister.add(clazz);
            return;
        }
        ConvertUtils.register((Converter)lookupConverter, (Class)clazz);
    }

    public static void changeFileExtensions(String fromExtn, String toExtn, String directoryPath) throws IOException {
        final String fromExtension = fromExtn;
        File dir = new File(directoryPath);
        String target = "";
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(fromExtension);
            }
        };
        String[] files = dir.list(filter);
        for (int i = 0; i < files.length; ++i) {
            String extn = RawFileDataContainerUtils.getFileExtension(files[i]);
            if (!extn.equalsIgnoreCase(fromExtension)) continue;
            target = files[i].replaceAll(extn, toExtn);
            new File(directoryPath + files[i]).renameTo(new File(directoryPath + target));
        }
    }

    public static String getFileExtension(String f) {
        String ext = "";
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            ext = f.substring(i + 1);
        }
        return ext;
    }

    public static synchronized void cleanUnregisteredLookups(Converter registeredLookupConverter) {
        Validate.notNull((Object)registeredLookupConverter, (String)"registeredLookupConverter can not be null");
        lookupConverter = registeredLookupConverter;
        if (!lookupsToRegister.isEmpty()) {
            Iterator itr = lookupsToRegister.iterator();
            while (itr.hasNext()) {
                ConvertUtils.register((Converter)lookupConverter, (Class)((Class)itr.next()));
            }
        }
        lookupsToRegister.clear();
    }

    public static void autoRegisterConvertersForClass(Class clazz) {
        RawFileDataContainerUtils.doAutoRegisterConvertersForClass(clazz, new HashMap());
    }

    private static void doAutoRegisterConvertersForClass(Class clazz, Map ignoreTheseClasses) {
        if (ignoreTheseClasses.containsKey(clazz)) {
            return;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        HashSet<Class> classesAutoRegistered = (HashSet<Class>)classLoaderToClassesAutoRegistered.get(currentClassLoader);
        if (classesAutoRegistered == null) {
            classesAutoRegistered = new HashSet<Class>();
            classLoaderToClassesAutoRegistered.put(currentClassLoader, classesAutoRegistered);
        } else if (classesAutoRegistered.contains(clazz)) {
            return;
        }
        classesAutoRegistered.add(clazz);
        ignoreTheseClasses.put(clazz, null);
        PropertyDescriptor[] props = PropertyUtils.getPropertyDescriptors((Class)clazz);
        Converter wellKnownConverter = null;
        for (int i = 0; i < props.length; ++i) {
            if (AbstractEntity.class.isAssignableFrom(props[i].getPropertyType())) {
                RawFileDataContainerUtils.doAutoRegisterConvertersForClass(props[i].getPropertyType(), ignoreTheseClasses);
            }
            Converter converter = wellKnownConverter = converters != null ? (Converter)converters.get(props[i].getPropertyType().getName()) : null;
            if (Lookup.class.isAssignableFrom(props[i].getPropertyType())) {
                RawFileDataContainerUtils.registerConverterForLookupClass(props[i].getPropertyType());
                continue;
            }
            if (ConvertUtils.lookup(props[i].getPropertyType()) != null || wellKnownConverter == null) continue;
            ConvertUtils.register((Converter)wellKnownConverter, props[i].getPropertyType());
        }
    }

    public static void setConvertedField(Object instance, String property, String rawValue) throws Exception {
        if (StringUtils.isNotBlank((String)rawValue)) {
            BeanUtils.copyProperty((Object)instance, (String)property, (Object)rawValue);
        }
    }

    public static Lookup convertToLookup(Class clazz, String code) {
        return (Lookup)lookupConverter.convert(clazz, (Object)code);
    }

    public static Object[] parseMultipleValues(String rawData, String primaryDelimiter, String secondaryDelimiter, int dataSize) {
        if (StringUtils.isBlank((String)rawData)) {
            return null;
        }
        Object[] splitByPrimary = rawData.split("\\" + primaryDelimiter);
        Object[] groupedData = new Object[splitByPrimary.length];
        if (secondaryDelimiter == null) {
            return splitByPrimary;
        }
        String[] splitBySecondaryActual = null;
        String[] splitBySecondary = null;
        for (int i = 0; i < splitByPrimary.length; ++i) {
            splitBySecondary = new String[dataSize];
            splitBySecondaryActual = ((String)splitByPrimary[i]).split("\\" + secondaryDelimiter);
            for (int j = 0; j < splitBySecondaryActual.length; ++j) {
                splitBySecondary[j] = splitBySecondaryActual[j];
            }
            groupedData[i] = splitBySecondary;
        }
        return groupedData;
    }

    public static String formatMultipleValues(Collection data, String delimiter) {
        StringBuffer buf = new StringBuffer();
        Iterator itr = data != null ? data.iterator() : null;
        Object obj = null;
        while (itr != null && itr.hasNext()) {
            obj = itr.next();
            if (obj instanceof Lookup) {
                buf.append(RawFileDataContainerUtils.formatLookup(obj));
            } else {
                buf.append((Object)obj);
            }
            if (!itr.hasNext()) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static List parseMultipleValues(String data, String delimiter) {
        ArrayList<String> coll = new ArrayList<String>();
        if (StringUtils.isBlank((String)data)) {
            return coll;
        }
        String[] tokens = data.split("\\" + delimiter);
        for (int j = 0; tokens != null && j < tokens.length; ++j) {
            coll.add(tokens[j]);
        }
        return coll;
    }

    public static Set parseMultipleLookupValues(String data, String delimiter, Class lookupClass) {
        HashSet<Lookup> coll = new HashSet<Lookup>();
        if (StringUtils.isBlank((String)data)) {
            return coll;
        }
        String[] tokens = data.split("\\" + delimiter);
        for (int j = 0; tokens != null && j < tokens.length; ++j) {
            coll.add(RawFileDataContainerUtils.convertToLookup(lookupClass, tokens[j]));
        }
        return coll;
    }

    public static String formatLookup(Lookup lookup) {
        return lookup != null ? lookup.getCode() : "";
    }

    public static Map getConverters() {
        return converters;
    }

    public static void setConverters(Map converters) {
        RawFileDataContainerUtils.converters = converters;
    }

    static {
        lookupsToRegister = new HashSet();
        classLoaderToClassesAutoRegistered = new HashMap();
    }
}

