/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.io;

import gov.va.med.fw.io.FileFieldMetaData;
import gov.va.med.fw.io.RawFileDataContainer;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ClassMapping
extends AbstractComponent {
    private Class targetClass;
    private List fieldsMetaData;
    private Map fieldsMetaDataMap;
    private boolean explicitFieldsMetaDataOrdering = false;
    private boolean sectionHeaderOnSeparateLine = true;

    public List getFieldsMetaData() {
        return this.fieldsMetaData;
    }

    public void setFieldsMetaData(List fieldsMetaData) {
        this.fieldsMetaData = fieldsMetaData;
    }

    public boolean hasFieldsMetaData() {
        return this.fieldsMetaData != null && !this.fieldsMetaData.isEmpty();
    }

    public boolean isExplicitFieldsMetaDataOrdering() {
        return this.explicitFieldsMetaDataOrdering;
    }

    public void setExplicitFieldsMetaDataOrdering(boolean explicitFieldsMetaDataOrdering) {
        this.explicitFieldsMetaDataOrdering = explicitFieldsMetaDataOrdering;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public FileFieldMetaData getFieldMetaData(String name) {
        return this.fieldsMetaDataMap != null ? (FileFieldMetaData)((Object)this.fieldsMetaDataMap.get(name)) : null;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.targetClass, (String)"targetClass can not be null");
        if ((this.fieldsMetaData == null || this.fieldsMetaData.isEmpty()) && !RawFileDataContainer.class.isAssignableFrom(this.targetClass)) {
            throw new InvalidConfigurationException("Either fieldsMetaData must be provided or the targetClass must implement RawFileDataContainer");
        }
        if (this.fieldsMetaData != null) {
            this.fieldsMetaDataMap = new HashMap();
            Iterator itr = this.fieldsMetaData.iterator();
            FileFieldMetaData meta = null;
            while (itr.hasNext()) {
                meta = (FileFieldMetaData)((Object)itr.next());
                this.fieldsMetaDataMap.put(meta.getName(), meta);
            }
        }
    }

    public boolean isSectionHeaderOnSeparateLine() {
        return this.sectionHeaderOnSeparateLine;
    }

    public void setSectionHeaderOnSeparateLine(boolean sectionHeaderOnSeparateLine) {
        this.sectionHeaderOnSeparateLine = sectionHeaderOnSeparateLine;
    }
}

