/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.InvalidSegmentException;
import gov.va.med.fw.hl7.MessageParser;
import gov.va.med.fw.hl7.constants.DelimeterConstants;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Segment
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Log logger = LogFactory.getLog(this.getClass());
    private String delimiter = "^";
    private String[] encoders = DelimeterConstants.DEFAULT_ENCODERS;
    private String elementData = null;
    private List elementList = null;
    private String name = null;
    private boolean propertyChanged = false;
    public static String NULL = "null";

    public Segment() {
        this.elementList = new ArrayList();
    }

    public Segment(String[] encodingChars, String elementDelimiter, String segmentData) throws InvalidSegmentException {
        if (encodingChars == null || encodingChars.length != 4) {
            throw new InvalidSegmentException("Invalid encoding characters to encode a segment");
        }
        if (segmentData == null) {
            throw new InvalidSegmentException("Invalid segment data to encode");
        }
        if (elementDelimiter == null) {
            throw new InvalidSegmentException("Invalid segment delimiter to use for encoding segment data");
        }
        int delimiterPos = segmentData.indexOf(elementDelimiter);
        if (delimiterPos == -1) {
            throw new InvalidSegmentException("Invalid segment delimiter in segment: " + segmentData);
        }
        this.delimiter = elementDelimiter;
        this.encoders = encodingChars;
        this.name = segmentData.substring(0, delimiterPos);
        this.elementData = segmentData.substring(this.name.length(), segmentData.length());
        this.elementList = MessageParser.parseElements(this.name, this.delimiter, this.elementData);
    }

    public Segment(String data) throws InvalidSegmentException {
        this(DelimeterConstants.DEFAULT_ENCODERS, "^", data);
    }

    public Segment(String[] encodingChars, String elementDelimiter, String segmentName, List segmentElements) throws InvalidSegmentException {
        this(encodingChars, elementDelimiter, MessageParser.parseElements(segmentName, elementDelimiter, segmentElements));
    }

    public Segment(String name, List elements) throws InvalidSegmentException {
        this(DelimeterConstants.DEFAULT_ENCODERS, "^", name, elements);
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getElementData() {
        if (this.elementData == null || this.propertyChanged) {
            Segment segment = this;
            synchronized (segment) {
                String name = this.getName();
                String segmentData = MessageParser.parseElements(name, this.getElementDelimiter(), this.elementList);
                this.elementData = segmentData.substring(name.length(), segmentData.length());
                this.propertyChanged = false;
            }
        }
        return this.elementData;
    }

    public String getElementDelimiter() {
        return this.delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElements() throws InvalidSegmentException {
        if (this.elementList == null) {
            Segment segment = this;
            synchronized (segment) {
                try {
                    this.elementList = MessageParser.parseElements(this.getName(), this.getElementDelimiter(), this.getElementData());
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidSegmentException("Failed to get a list of elements", e);
                }
            }
        }
        return this.elementList;
    }

    public String getComponentDelimiter() {
        return this.encoders[0];
    }

    public String getRepeatDelimiter() {
        return this.encoders[1];
    }

    public String getEscapeDelimiter() {
        return this.encoders[2];
    }

    public String getSubComponentDelimiter() {
        return this.encoders[3];
    }

    public String[] getSubComponents(String elements) {
        return MessageParser.parseElement(elements, this.getSubComponentDelimiter());
    }

    public String[] getRepeatComponents(String elements) {
        return MessageParser.parseElement(elements, this.getRepeatDelimiter());
    }

    public String[] getComponents(String elements) {
        return MessageParser.parseElement(elements, this.getComponentDelimiter());
    }

    public String[] getEscapeComponents(String elements) {
        return MessageParser.parseElement(elements, this.getEscapeDelimiter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setElement(String value, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Invalid element index");
        }
        Segment segment = this;
        synchronized (segment) {
            int size = this.elementList.size();
            if (index > size) {
                for (int i = size; i < index; ++i) {
                    this.elementList.add(i, null);
                }
                this.elementList.add(index, this.getSequenceValue(value));
            } else if (index < size) {
                Object current = this.elementList.get(index);
                if (!ObjectUtils.equals(current, (Object)value)) {
                    this.elementList.remove(index);
                    this.elementList.add(index, this.getSequenceValue(value));
                }
            } else {
                this.elementList.add(index, this.getSequenceValue(value));
            }
            this.propertyChanged = true;
        }
    }

    protected String getElement(int index) {
        String value = null;
        if (index >= this.elementList.size()) {
            return null;
        }
        Object element = this.elementList.get(index);
        if (element != null) {
            value = element instanceof String ? (String)element : element.toString();
        }
        return value;
    }

    protected void setName(String value) {
        this.name = value;
    }

    protected void setElementDelimiter(String input) {
        this.delimiter = input;
    }

    private String getSequenceValue(String value) {
        String newValue = value;
        if (value == null) {
            newValue = "";
        } else if (value.length() == 0) {
            newValue = null;
        } else if (NULL.equals(value)) {
            newValue = "";
        }
        return newValue;
    }
}

