/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.ZE2;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZEN;
import gov.va.med.fw.hl7.segment.ZIE;
import gov.va.med.fw.hl7.segment.ZIO;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.hl7.segment.ZSP;
import java.util.List;

public class HL7SegmentParser {
    public static PID getPIDSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("PID") : null;
        return s instanceof PID ? (PID)s : null;
    }

    public static ZPD getZPDSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("ZPD") : null;
        return s instanceof ZPD ? (ZPD)s : null;
    }

    public static ZEN getZENSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("ZEN") : null;
        return s instanceof ZEN ? (ZEN)s : null;
    }

    public static ZEL getZELSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("ZEL") : null;
        return s instanceof ZEL ? (ZEL)s : null;
    }

    public static MSH getMSHSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("MSH") : null;
        return s instanceof MSH ? (MSH)s : null;
    }

    public static MSA getMSASegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("MSA") : null;
        return s instanceof MSA ? (MSA)s : null;
    }

    public static ZIO getZIOSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("ZIO") : null;
        return s instanceof ZIO ? (ZIO)s : null;
    }

    public static ZSP getZSPSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("ZSP") : null;
        return s instanceof ZSP ? (ZSP)s : null;
    }

    public static ZIE getZIESegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("ZIE") : null;
        return s instanceof ZIE ? (ZIE)s : null;
    }

    public static List getZMHSegments(Message message) throws InvalidMessageException {
        return message != null ? message.getSegments("ZMH") : null;
    }

    public static List getZEMSegments(Message message) throws InvalidMessageException {
        return message != null ? message.getSegments("ZEM") : null;
    }

    public static List getZRDSegments(Message message) throws InvalidMessageException {
        return message != null ? message.getSegments("ZRD") : null;
    }

    public static List getZHPSegments(Message message) throws InvalidMessageException {
        return message != null ? message.getSegments("ZHP") : null;
    }

    public static String getAcknowledgmentCode(Message message) throws InvalidMessageException {
        MSA segment = HL7SegmentParser.getMSASegment(message);
        return segment != null ? segment.getAcknowledgementCode() : null;
    }

    public static String getAcknowledgmentTextMessage(Message message) throws InvalidMessageException {
        MSA segment = HL7SegmentParser.getMSASegment(message);
        return segment != null ? segment.getTextMessage() : null;
    }

    public static BHS getBHSSegment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("BHS") : null;
        return s instanceof BHS ? (BHS)s : null;
    }

    public static ZE2 getZE2Segment(Message message) throws InvalidMessageException {
        Segment s = message != null ? message.getSegment("ZE2") : null;
        return s instanceof ZE2 ? (ZE2)s : null;
    }
}

