/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.hl7;

import gov.va.med.fw.hl7.HL7SegmentParser;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.segment.BHS;
import gov.va.med.fw.hl7.segment.MSA;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.PID;
import gov.va.med.fw.hl7.segment.ZE2;
import gov.va.med.fw.hl7.segment.ZEL;
import gov.va.med.fw.hl7.segment.ZEN;
import gov.va.med.fw.hl7.segment.ZIE;
import gov.va.med.fw.hl7.segment.ZIO;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.hl7.segment.ZSP;
import java.util.List;
import org.apache.commons.lang.Validate;

public class HL7Message
extends Message {
    private static final long serialVersionUID = -7608890089088074678L;

    public HL7Message(Message message) {
        Validate.notNull((Object)message, (String)"An HL7 message must not be null");
        this.setMessageData(message.getMessageData());
        this.setType(message.getType());
    }

    public HL7Message(String data) throws InvalidMessageException {
        super(data);
    }

    public HL7Message(String data, String type) throws InvalidMessageException {
        super(data, type);
    }

    public HL7Message(List segments) throws InvalidMessageException {
        super(segments);
    }

    public HL7Message(List segments, String type) throws InvalidMessageException {
        super(segments, type);
    }

    public PID getPIDSegment() throws InvalidMessageException {
        return HL7SegmentParser.getPIDSegment(this);
    }

    public ZPD getZPDSegment() throws InvalidMessageException {
        return HL7SegmentParser.getZPDSegment(this);
    }

    public ZEN getZENSegment() throws InvalidMessageException {
        return HL7SegmentParser.getZENSegment(this);
    }

    public ZEL getZELSegment() throws InvalidMessageException {
        return HL7SegmentParser.getZELSegment(this);
    }

    public MSH getMSHSegment() throws InvalidMessageException {
        return HL7SegmentParser.getMSHSegment(this);
    }

    public MSA getMSASegment() throws InvalidMessageException {
        return HL7SegmentParser.getMSASegment(this);
    }

    public ZIO getZIOSegment() throws InvalidMessageException {
        return HL7SegmentParser.getZIOSegment(this);
    }

    public ZSP getZSPSegment() throws InvalidMessageException {
        return HL7SegmentParser.getZSPSegment(this);
    }

    public ZIE getZIESegment() throws InvalidMessageException {
        return HL7SegmentParser.getZIESegment(this);
    }

    public List getZMHSegments() throws InvalidMessageException {
        return HL7SegmentParser.getZMHSegments(this);
    }

    public List getZEMSegments() throws InvalidMessageException {
        return HL7SegmentParser.getZEMSegments(this);
    }

    public List getZRDSegments() throws InvalidMessageException {
        return HL7SegmentParser.getZRDSegments(this);
    }

    public String getAcknowledgmentCode() throws InvalidMessageException {
        return HL7SegmentParser.getAcknowledgmentCode(this);
    }

    public String getAcknowledgmentTextMessage() throws InvalidMessageException {
        return HL7SegmentParser.getAcknowledgmentTextMessage(this);
    }

    public BHS getBHSSegment() throws InvalidMessageException {
        return HL7SegmentParser.getBHSSegment(this);
    }

    public ZE2 getZE2Segment() throws InvalidMessageException {
        return HL7SegmentParser.getZE2Segment(this);
    }

    public List getZHPSegment() throws InvalidMessageException {
        return HL7SegmentParser.getZHPSegments(this);
    }
}

