/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.conversion;

import gov.va.med.fw.conversion.CopyService;
import gov.va.med.fw.conversion.CopyServiceException;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.Reflector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.Validate;

public class CopyServiceImpl
extends AbstractComponent
implements CopyService {
    private List commonExcludePropertyList;
    private Map includePropertyMap;
    private Map excludePropertyMap;
    private Map complexPropertyMap;
    private Map classNameAliasMap;

    @Override
    public void copy(AbstractEntity source, AbstractEntity target) throws CopyServiceException {
        Validate.notNull((Object)source, (String)"Source object must not be null");
        Validate.notNull((Object)target, (String)"Target object must not be null");
        PropertyUtilsBean propUtils = new PropertyUtilsBean();
        this.copy(source, target, propUtils);
    }

    @Override
    public AbstractEntity getCopy(AbstractEntity source) throws CopyServiceException {
        Validate.notNull((Object)source, (String)"Source object must not be null");
        if (AbstractLookup.class.isAssignableFrom(source.getClass())) {
            return source;
        }
        PropertyUtilsBean propUtils = new PropertyUtilsBean();
        return (AbstractEntity)this.getCopy(source, propUtils);
    }

    protected Object getCopy(Object source, PropertyUtilsBean propUtils) throws CopyServiceException {
        if (source == null) {
            return null;
        }
        Object target = null;
        try {
            target = source.getClass().newInstance();
            this.copy(source, target, propUtils);
            List complexProperties = this.getComplexPropertyList(target.getClass().getName());
            this.copyComplexProperties(source, target, complexProperties, propUtils);
            return target;
        }
        catch (Exception e) {
            throw new CopyServiceException("Could not create a new instance", e);
        }
    }

    protected void copyComplexProperties(Object source, Object target, List properties, PropertyUtilsBean propUtils) throws Exception {
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (int i = 0; i < properties.size(); ++i) {
            String propName = (String)properties.get(i);
            Object propValue = null;
            try {
                propValue = propUtils.getSimpleProperty(source, propName);
            }
            catch (Exception e) {
                throw new CopyServiceException("getSimpleProperty failed class: " + source.getClass().getName() + " property: " + propName);
            }
            if (propValue == null) continue;
            Class<?> propType = propValue.getClass();
            if (Map.class.isAssignableFrom(propType)) {
                Map map = (Map)propValue;
                for (Object itemKey : map.keySet()) {
                    Object itemValue = map.get(itemKey);
                    if (itemValue == null) continue;
                    Object itemCopy = this.getCopy(itemValue, propUtils);
                    String addMethod = this.getAddMethodName(itemCopy);
                    Object[] values = new Object[]{itemKey, itemCopy};
                    this.executeMethod(target, addMethod, values);
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(propType)) {
                for (Object item : (Collection)propValue) {
                    Object itemCopy = this.getCopy(item, propUtils);
                    String addMethod = this.getAddMethodName(item);
                    this.executeMethod(target, addMethod, new Object[]{itemCopy});
                }
                continue;
            }
            Object propCopy = this.getCopy(propValue, propUtils);
            propUtils.setSimpleProperty(target, propName, propCopy);
        }
    }

    protected void copy(Object source, Object target, PropertyUtilsBean propUtils) throws CopyServiceException {
        try {
            List includePropertyList = this.getIncludePropertyList(source.getClass().getName());
            List excludePropertyList = this.getExcludePropertyList(source.getClass().getName());
            if (includePropertyList != null && !includePropertyList.isEmpty() && excludePropertyList != null && !excludePropertyList.isEmpty()) {
                throw new CopyServiceException("Both include and exclude properties must not be specified.");
            }
            if (includePropertyList != null && !includePropertyList.isEmpty()) {
                this.copyIncludes(source, target, includePropertyList, propUtils);
            } else {
                Map sourcePropertyMap = this.getReadableProperties(source, propUtils);
                if (excludePropertyList != null && !excludePropertyList.isEmpty()) {
                    this.copyExcludes(sourcePropertyMap, target, excludePropertyList, propUtils);
                } else {
                    this.copyAll(sourcePropertyMap, target, propUtils);
                }
            }
        }
        catch (CopyServiceException copyEx) {
            throw copyEx;
        }
        catch (Exception ex) {
            throw new CopyServiceException("Error while copying the properties.", ex);
        }
    }

    public List getCommonExcludePropertyList() {
        return this.commonExcludePropertyList != null ? this.commonExcludePropertyList : new ArrayList();
    }

    public void setCommonExcludePropertyList(List commonExcludePropertyList) {
        if (commonExcludePropertyList == null) {
            commonExcludePropertyList = new ArrayList();
        }
        this.commonExcludePropertyList = commonExcludePropertyList;
    }

    public void setExcludePropertyMap(Map excludePropertyMap) {
        this.excludePropertyMap = excludePropertyMap;
    }

    public void setIncludePropertyMap(Map includePropertyMap) {
        this.includePropertyMap = includePropertyMap;
    }

    public List getExcludePropertyList(String className) {
        List exList = this.excludePropertyMap != null ? (List)this.excludePropertyMap.get(className) : null;
        return exList;
    }

    public List getIncludePropertyList(String className) {
        return this.includePropertyMap != null ? (List)this.includePropertyMap.get(className) : null;
    }

    public List getComplexPropertyList(String className) {
        return this.complexPropertyMap != null ? (List)this.complexPropertyMap.get(className) : null;
    }

    public void setComplexPropertyMap(Map complexPropertyMap) {
        this.complexPropertyMap = complexPropertyMap;
    }

    protected void copyIncludes(Map sourcePropertyMap, Object target, List includePropertyList, PropertyUtilsBean propUtils) throws Exception {
        for (String key : includePropertyList) {
            this.setSimpleProperty(target, key, sourcePropertyMap.get(key), propUtils);
        }
    }

    protected void copyIncludes(Object source, Object target, List includePropertyList, PropertyUtilsBean propUtils) throws Exception {
        for (String key : includePropertyList) {
            this.setSimpleProperty(target, key, propUtils.getNestedProperty(source, key), propUtils);
        }
    }

    protected void copyExcludes(Map sourcePropertyMap, Object target, List excludePropertyList, PropertyUtilsBean propUtils) throws Exception {
        String key2 = null;
        for (String key2 : sourcePropertyMap.keySet()) {
            if (excludePropertyList.contains(key2) || this.getCommonExcludePropertyList().contains(key2)) continue;
            this.setSimpleProperty(target, key2, sourcePropertyMap.get(key2), propUtils);
        }
    }

    protected void copyAll(Map sourcePropertyMap, Object target, PropertyUtilsBean propUtils) throws Exception {
        String key2 = null;
        for (String key2 : sourcePropertyMap.keySet()) {
            if (this.getCommonExcludePropertyList().contains(key2)) continue;
            this.setSimpleProperty(target, key2, sourcePropertyMap.get(key2), propUtils);
        }
    }

    private Map getReadableProperties(Object source, PropertyUtilsBean propUtils) throws CopyServiceException {
        Map map = null;
        try {
            map = propUtils.describe(source);
        }
        catch (Exception ex) {
            throw new CopyServiceException("Error while extracting the source properties.", ex);
        }
        return map;
    }

    private void setSimpleProperty(Object bean, String name, Object value, PropertyUtilsBean propUtils) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Validate.notNull((Object)bean, (String)"No bean specified");
        Validate.notNull((Object)name, (String)"No name specified");
        if (!propUtils.isWriteable(bean, name)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No setter method for property '" + name + "' in class '" + bean.getClass().getName()));
            }
            return;
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("Nested property names are not allowed");
        }
        if (name.indexOf(91) >= 0) {
            throw new IllegalArgumentException("Indexed property names are not allowed");
        }
        if (name.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Mapped property names are not allowed");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "'");
            }
            ((DynaBean)bean).set(name, value);
            return;
        }
        PropertyDescriptor descriptor = propUtils.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'");
        }
        descriptor.getWriteMethod();
        Method writeMethod = descriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method");
        }
        Object[] values = new Object[]{value};
        writeMethod.invoke(bean, values);
    }

    protected Object executeMethod(Object targetObj, String methodName, Object[] params) throws Exception {
        if (targetObj != null && methodName != null && params != null && params[0] != null) {
            Class currentClass = targetObj.getClass();
            if (Class.class.isAssignableFrom(targetObj.getClass())) {
                currentClass = (Class)targetObj;
            }
            while (currentClass != null) {
                try {
                    Method method = Reflector.findMethod(currentClass, methodName, Reflector.typesOf(params));
                    return method.invoke(targetObj, params);
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (Exception ex) {
                    currentClass = currentClass.getSuperclass();
                }
            }
            throw new NoSuchMethodException("Unable to find a matching '" + methodName + "' method in the '" + targetObj.getClass().getName() + "' class hierarchy.");
        }
        return null;
    }

    protected String getAddMethodName(Object obj) {
        String className = obj.getClass().getName();
        className = this.getAliasName(className);
        return "add" + className.substring(className.lastIndexOf(46) + 1);
    }

    protected String getAliasName(String className) {
        String alias = null;
        if (this.classNameAliasMap != null) {
            alias = (String)this.classNameAliasMap.get(className);
        }
        return alias == null ? className : alias;
    }

    public Map getClassNameAliasMap() {
        return this.classNameAliasMap;
    }

    public void setClassNameAliasMap(Map classNameAliasMap) {
        this.classNameAliasMap = classNameAliasMap;
    }
}

