/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.cache;

import gov.va.med.fw.cache.CacheStrategy;
import gov.va.med.fw.service.AbstractComponent;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.Validate;

public class MethodCacheInterceptor
extends AbstractComponent
implements MethodInterceptor {
    private CacheStrategy cacheStrategy = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.cacheStrategy, (String)"A cache strategy must be configured");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String targetName = invocation.getThis().getClass().getName();
        String methodName = invocation.getMethod().getName();
        Object[] arguments = invocation.getArguments();
        this.logger.debug((Object)"looking for method result in cache");
        String cacheKey = this.getCacheKey(targetName, methodName, arguments);
        Object result = this.cacheStrategy.getItem(cacheKey);
        if (result == null) {
            this.logger.debug((Object)"calling intercepted method");
            result = invocation.proceed();
            this.logger.debug((Object)"caching result");
            this.cacheStrategy.cacheItem(cacheKey, result);
        }
        return result;
    }

    private String getCacheKey(String targetName, String methodName, Object[] arguments) {
        StringBuffer sb = new StringBuffer();
        sb.append(targetName).append(".").append(methodName);
        if (arguments != null && arguments.length != 0) {
            for (int i = 0; i < arguments.length; ++i) {
                sb.append(".").append(arguments[i]);
            }
        }
        return sb.toString();
    }
}

