/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.cache;

import gov.va.med.fw.cache.AbstractCacheManager;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.transaction.TransactionSynchronizationForCacheManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class EntityCacheManager
extends AbstractCacheManager {
    private static final long serialVersionUID = 1633957061242960133L;

    protected boolean shouldCacheItem() {
        return TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.hasResource((Object)TransactionSynchronizationForCacheManager.CACHE_AUTOCLEANUP_VIA_TRANSACTION_SYNCHRONIZATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeItem(AbstractEntity entity, Object key) {
        Validate.notNull((Object)entity, (String)"An entity must not be null");
        Validate.notNull((Object)key, (String)"A key must not be null");
        if (!this.shouldCacheItem()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Not caching entity with key [" + key + "] since either outside of Transaction scope or TransactionSynchronizationForCacheManager not registered"));
            }
        } else {
            String name = this.getCacheName();
            if (name != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("[Cache name: " + name + "] - adding data of type: " + entity.getClass().getName()));
                }
                if (this.containsItem(name)) {
                    Map cache = (Map)this.getItem(name);
                    cache.put(key, entity);
                } else {
                    EntityCacheManager entityCacheManager = this;
                    synchronized (entityCacheManager) {
                        HashMap<Object, AbstractEntity> cache = new HashMap<Object, AbstractEntity>();
                        cache.put(key, entity);
                        this.cacheItem(name, cache);
                    }
                }
            }
        }
    }

    public AbstractEntity getItem(EntityKey key) {
        String name;
        AbstractEntity entity = null;
        if (key != null && this.containsItem(name = TransactionSynchronizationManager.getCurrentTransactionName())) {
            Map cache = (Map)this.getItem(name);
            Object value = cache.get(key);
            entity = value instanceof AbstractEntity ? (AbstractEntity)value : null;
        }
        return entity;
    }

    protected String getCacheName() {
        String name = TransactionSynchronizationManager.getCurrentTransactionName();
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            name = String.valueOf(Math.random());
            TransactionSynchronizationManager.setCurrentTransactionName((String)name);
        }
        return name;
    }
}

