/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.cache;

import gov.va.med.fw.cache.CacheStrategy;
import gov.va.med.fw.service.AbstractComponent;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.Validate;

public class EHCacheStrategy
extends AbstractComponent
implements CacheStrategy {
    private static final long serialVersionUID = -8313273199973981560L;
    private Cache cache = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.cache, (String)"A cache must be configured");
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    @Override
    public Object getItem(Object key) {
        Validate.notNull((Object)key, (String)"A key to look up a cache item must not be null");
        Element item = this.cache.get(key);
        return item != null ? item.getObjectValue() : null;
    }

    @Override
    public Object removeItem(Object key) {
        Validate.notNull((Object)key, (String)"A key to look up a cache item must not be null");
        Object value = null;
        Element item = this.cache.get(key);
        if (item != null) {
            value = item.getObjectKey();
            this.cache.remove(item.getKey());
        }
        return value;
    }

    @Override
    public void cacheItem(Object key, Object value) {
        this.cache.put(new Element(key, value));
    }

    @Override
    public boolean containsItem(Object key) {
        return this.cache.get(key) != null;
    }
}

