/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.DataFileProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HandbookMailingResponseErrorFileProcessStatistics
extends DataFileProcessStatistics {
    private static final long serialVersionUID = -1744727060006544164L;
    private String processedFilePath;
    private List processedFiles = new ArrayList();
    private int numH400HRecordsProcessed = 0;
    private int numH400BRecordsProcessed = 0;
    private int numH400FRecordsProcessed = 0;
    private StringBuffer errorH400HReason = new StringBuffer();
    private StringBuffer errorH400BReason = new StringBuffer();
    private StringBuffer errorH400FReason = new StringBuffer();

    public ProcessStatistics createProcessStatistics() {
        return new HandbookMailingResponseErrorFileProcessStatistics();
    }

    @Override
    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("Number of F400H Records Processed", this.numH400HRecordsProcessed);
        builder.append("Number of F400B Records Processed", this.numH400BRecordsProcessed);
        builder.append("Number of F400F Records Processed", this.numH400FRecordsProcessed);
        builder.append("List of F400H Reason(s)", (Object)this.errorH400HReason.toString());
        builder.append("List of F400B Reason(s)", (Object)this.errorH400BReason.toString());
        builder.append("List of F400F Reason(s)", (Object)this.errorH400FReason.toString());
    }

    public void appendH400HReason(String reason) {
        if (this.errorH400HReason.indexOf(reason) == -1) {
            this.errorH400HReason.append(reason + "^");
        }
    }

    public void appendH400BReason(String reason) {
        if (this.errorH400BReason.indexOf(reason) == -1) {
            this.errorH400BReason.append(reason + "^");
        }
    }

    public void appendH400FReason(String reason) {
        if (this.errorH400FReason.indexOf(reason) == -1) {
            this.errorH400FReason.append(reason + "^");
        }
    }

    public int getH400BRecords() {
        return this.numH400BRecordsProcessed;
    }

    public void setH400BRecordsProcessed(int numH400BRecordsProcessed) {
        this.numH400BRecordsProcessed = numH400BRecordsProcessed;
    }

    public void incrementH400BRecords() {
        ++this.numH400BRecordsProcessed;
    }

    public int getH400FRecords() {
        return this.numH400FRecordsProcessed;
    }

    public void setH400FRecordsProcessed(int numH400FRecordsProcessed) {
        this.numH400FRecordsProcessed = numH400FRecordsProcessed;
    }

    public void incrementH400FRecords() {
        ++this.numH400FRecordsProcessed;
    }

    public int getH400HRecords() {
        return this.numH400HRecordsProcessed;
    }

    public void setH400HRecordsProcessed(int numRecordsProcessed) {
        this.numH400HRecordsProcessed = numRecordsProcessed;
    }

    public void incrementH400HRecordsProcessed() {
        ++this.numH400HRecordsProcessed;
    }

    @Override
    public Map statsMap() throws Exception {
        Map data = super.statsMap();
        data.put("Number of F400H Records Processed", new Integer(this.numH400HRecordsProcessed));
        data.put("Number of F400B Records Processed", new Integer(this.numH400BRecordsProcessed));
        data.put("Number of F400F Records Processed", new Integer(this.numH400FRecordsProcessed));
        return data;
    }

    @Override
    public Map mapFromCSV(String csv) {
        Map data = super.mapFromCSV(csv);
        String processFilesStr = (String)data.get("processedFiles");
        if (StringUtils.isNotBlank((String)processFilesStr)) {
            data.put("processedFiles", DataFileProcessStatistics.listFromString(processFilesStr));
        }
        return data;
    }

    @Override
    public void appendStats(ProcessStatistics stats) {
        DataFileProcessStatistics _stats = (DataFileProcessStatistics)stats;
        this.setProcessName(_stats.getProcessName());
        this.setProcessedFilePath(_stats.getProcessedFilePath());
        this.setProcessingStartDate(_stats.getProcessingStartDate());
        this.setExecutedOnServer(_stats.getExecutedOnServer());
        this.setProcessedFiles(_stats.getProcessedFiles());
    }
}

