/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessCompletedHandler;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.io.writer.FormattedFileWriter;
import gov.va.med.fw.service.AbstractComponent;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public class HandbookCMSIncomingFileProcessCompletedHandler
extends AbstractComponent
implements DataProcessCompletedHandler {
    private FormattedFileWriter failedFileWriter;
    private FormattedFileWriter exceptionFileWriter;
    private boolean deleteInputFile = false;
    private String fileExention = ".txt";
    private String renameInputFileExtension = ".DONE";
    private static String DATE_FORMAT = "yyyyMMddHHmmss";

    @Override
    public void dataProcessingComplete(DataProcessExecutionContext context) {
        this.writeExceptionData(context);
        this.writeFailedData(context);
        if (!context.isInterrupted() && context instanceof DataFileProcessExecutionContext) {
            File inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile();
            if (this.deleteInputFile && !inputFile.delete()) {
                throw new IllegalStateException("Unable to delete input file: " + inputFile.getName());
            }
            if (this.renameInputFileExtension != null) {
                this.renameFile(inputFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeExceptionData(DataProcessExecutionContext context) {
        List exceptionData = this.getInterestedExceptionData(context);
        if (exceptionData != null && !exceptionData.isEmpty() && this.exceptionFileWriter != null) {
            this.exceptionFileWriter.appendData(exceptionData, this.getExceptionFileNameSuffixData(context));
        }
        List list = exceptionData;
        synchronized (list) {
            exceptionData.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeFailedData(DataProcessExecutionContext context) {
        List failedRecords = ((DataFileProcessExecutionContext)context).getFailedData();
        if (failedRecords != null && !failedRecords.isEmpty()) {
            this.failedFileWriter.appendData(failedRecords, this.getFailedFileName(context));
            List list = failedRecords;
            synchronized (list) {
                failedRecords.clear();
            }
        }
    }

    protected List getInterestedExceptionData(DataProcessExecutionContext context) {
        return context.getExceptionData();
    }

    protected Object getExceptionFileNameSuffixData(DataProcessExecutionContext context) {
        File inputFile = ((DataFileProcessExecutionContext)context).getCurrentFile();
        String inputFileName = inputFile.getName();
        return inputFileName;
    }

    protected String getFailedFileName(DataProcessExecutionContext context) {
        String currentFileName = ((DataFileProcessExecutionContext)context).getCurrentFile().getName();
        int currNumber = 0;
        String firstPart = currentFileName.substring(0, currentFileName.lastIndexOf(46));
        if (Pattern.matches("^(\\S+)_(\\d{1,2})\\.(\\S+)$", currentFileName)) {
            String digits = currentFileName.substring(currentFileName.lastIndexOf(95) + 1);
            digits = digits.substring(0, digits.lastIndexOf(46));
            try {
                currNumber = Integer.parseInt(digits);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (currNumber > 0 && currNumber < 10) {
            firstPart = currentFileName.substring(0, currentFileName.lastIndexOf(95));
        }
        String lastPart = this.fileExention;
        lastPart = ++currNumber <= 10 ? "_" + currNumber + this.fileExention : ".FAILED";
        String fileName = firstPart + lastPart;
        return fileName;
    }

    protected boolean renameFile(File inputFile) {
        String inputFilePath = inputFile.getParent();
        StringBuffer inputFileNameRoot = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(inputFile.getName(), ".");
        int tokenCount = st.countTokens();
        for (int i = 1; i < tokenCount; ++i) {
            inputFileNameRoot.append(st.nextToken());
            if (i == tokenCount - 1) continue;
            inputFileNameRoot.append(".");
        }
        if (tokenCount == 1) {
            inputFileNameRoot.append(inputFile.getName());
        }
        String newFileName = inputFileNameRoot.toString() + this.renameInputFileExtension;
        File newFile = new File(inputFilePath + File.separator + newFileName);
        int i = 1;
        while (newFile.exists()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Can not rename file to " + newFile.getName() + " since it exists already.  Trying one up number extension"));
            }
            newFile = new File(inputFilePath + File.separator + newFileName + i++);
        }
        boolean result = inputFile.renameTo(newFile);
        inputFile.setLastModified(new Date().getTime());
        return result;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)((Object)this.failedFileWriter));
    }

    public boolean isDeleteInputFile() {
        return this.deleteInputFile;
    }

    public void setDeleteInputFile(boolean deleteInputFile) {
        this.deleteInputFile = deleteInputFile;
    }

    public FormattedFileWriter getExceptionFileWriter() {
        return this.exceptionFileWriter;
    }

    public void setExceptionFileWriter(FormattedFileWriter exceptionFileWriter) {
        this.exceptionFileWriter = exceptionFileWriter;
    }

    public FormattedFileWriter getFailedFileWriter() {
        return this.failedFileWriter;
    }

    public void setFailedFileWriter(FormattedFileWriter failedFileWriter) {
        this.failedFileWriter = failedFileWriter;
    }

    public String getFileExention() {
        return this.fileExention;
    }

    public void setFileExention(String fileExention) {
        this.fileExention = fileExention;
    }

    public String getRenameInputFileExtension() {
        return this.renameInputFileExtension;
    }

    public void setRenameInputFileExtension(String renameInputFileExtension) {
        this.renameInputFileExtension = renameInputFileExtension;
    }
}

