/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryDetail;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessStatistics;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.persistent.DAOOperations;
import java.util.List;
import org.apache.commons.lang.Validate;

public abstract class AbstractDataQueryProcess
extends AbstractDataProcess {
    private DataQueryDetail queryDetail = new DataQueryDetail();
    private DAOOperations dao;

    @Override
    protected DataProcessExecutionContext createDataProcessExecutionContext() {
        DataQueryProcessExecutionContext context = new DataQueryProcessExecutionContext();
        context.setProcessStatistics(this.createProcessStatistics());
        return context;
    }

    @Override
    protected ProcessStatistics createProcessStatistics() {
        return new DataQueryProcessStatistics();
    }

    @Override
    protected List acquireData(DataProcessExecutionContext context) throws Exception {
        DataQueryProcessExecutionContext queryContext = (DataQueryProcessExecutionContext)context;
        queryContext.setCurrentDataQuery(this.queryDetail);
        List acquiredData = this.doAcquireData(queryContext);
        if (this.logger.isInfoEnabled() && acquiredData != null) {
            this.logger.info((Object)("AbstractDataQueryProcess acquired " + acquiredData.size() + " data records"));
        }
        return acquiredData;
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        return this.executeQuery(context);
    }

    protected List executeQuery(DataQueryProcessExecutionContext context) throws Exception {
        DataQueryDetail currentQuery = context.getCurrentDataQuery();
        return this.getDao().findByNamedQueryAndNamedParam(currentQuery.getQuery().getQuery(), currentQuery.getQuery().getParamNames(), currentQuery.getQuery().getParamValues());
    }

    public DAOOperations getDao() {
        return this.dao;
    }

    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    public String getQueryName() {
        return this.queryDetail.getQuery().getQuery();
    }

    public void setQueryName(String queryName) {
        this.queryDetail.getQuery().setQuery(queryName);
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.dao, (String)"A dao is needed to acquire data");
        this.validateQuery();
    }

    protected void validateQuery() {
        Validate.notNull((Object)((Object)this.queryDetail), (String)"A DataQueryDetail is needed to acquire data");
        Validate.notNull((Object)this.queryDetail.getQuery().getQuery(), (String)"A query name is needed to acquire data");
    }

    public String[] getParamNames() {
        return this.queryDetail.getQuery().getParamNames();
    }

    public void setParamNames(String[] paramNames) {
        this.queryDetail.getQuery().setParamNames(paramNames);
    }

    public Object[] getParamValues() {
        return this.queryDetail.getQuery().getParamValues();
    }

    public void setParamValues(Object[] paramValues) {
        this.queryDetail.getQuery().setParamValues(paramValues);
    }

    public DataQueryDetail getQueryDetail() {
        return this.queryDetail;
    }

    public void setQueryDetail(DataQueryDetail queryDetail) {
        this.queryDetail = queryDetail;
    }
}

