/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataFileProcessStatistics;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.io.parser.WildcardFileFilter;
import gov.va.med.fw.util.FileModifiedDateComparator;
import gov.va.med.fw.util.builder.Builder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.springframework.core.io.FileSystemResource;

public abstract class AbstractDataFileProcess
extends AbstractDataProcess {
    private Builder inputFileReader;
    private String inputFileLocation;
    private FilenameFilter inputFileFilter;
    private boolean handleEachFileSeparately = true;
    private boolean caseInsensitive = true;
    private boolean oneFileProcess = false;

    public boolean isOneFileProcess() {
        return this.oneFileProcess;
    }

    public void setOneFileProcess(boolean oneFileProcess) {
        this.oneFileProcess = oneFileProcess;
    }

    @Override
    protected DataProcessExecutionContext createDataProcessExecutionContext() {
        DataFileProcessStatistics stats = (DataFileProcessStatistics)this.createProcessStatistics();
        stats.setProcessedFilePath(this.inputFileLocation);
        DataFileProcessExecutionContext context = new DataFileProcessExecutionContext();
        context.setProcessStatistics(stats);
        return context;
    }

    @Override
    protected ProcessStatistics createProcessStatistics() {
        return new DataFileProcessStatistics();
    }

    @Override
    protected final void executeProcess(DataProcessExecutionContext context) throws Exception {
        if (this.hasExactlyOneInputFileToProcess()) {
            super.executeProcess(context);
        } else {
            DataFileProcessExecutionContext ctxt = (DataFileProcessExecutionContext)context;
            DataFileProcessStatistics dataStats = (DataFileProcessStatistics)ctxt.getProcessStatistics();
            FileSystemResource fileSystemResource = new FileSystemResource(this.inputFileLocation);
            File[] files = fileSystemResource.getFile().listFiles(this.inputFileFilter);
            String[] fileNames = null;
            if (files != null) {
                Arrays.sort(files, new FileModifiedDateComparator());
                fileNames = new String[files.length];
                for (int i = 0; i < files.length; ++i) {
                    fileNames[i] = files[i].getName();
                }
            }
            files = null;
            List specificFileData = null;
            fileSystemResource = null;
            if (fileNames == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("There were problems (eg, not a directory) trying to get input files at [" + this.inputFileLocation + "] for " + this.getProcessName()));
                }
            } else {
                if (fileNames.length == 0 && this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)("There are no input files at [" + this.inputFileLocation + "] for " + this.getProcessName()));
                }
                for (int i = 0; i < fileNames.length; ++i) {
                    fileSystemResource = new FileSystemResource(this.inputFileLocation + File.separator + fileNames[i]);
                    ctxt.setCurrentFile(fileSystemResource.getFile());
                    specificFileData = this.doAcquireData(ctxt, fileSystemResource);
                    this.processData(ctxt, specificFileData);
                    dataStats.addProcessedFile(fileNames[i]);
                    if (this.shouldUpdateJobResult(context)) {
                        this.updateJobResult(context);
                    }
                    if (!this.handleEachFileSeparately) continue;
                    this.logParsedFile(ctxt);
                    this.handleDataProcessCompleted(ctxt);
                    if (this.isOneFileProcess()) break;
                }
            }
            if (!this.handleEachFileSeparately) {
                this.logParsedFile(ctxt);
                this.handleDataProcessCompleted(ctxt);
            }
        }
    }

    private boolean hasExactlyOneInputFileToProcess() {
        boolean hasExactlyOneInputFileToProcess = false;
        FileSystemResource fileSystemResource = new FileSystemResource(this.inputFileLocation);
        if (this.inputFileFilter == null && !fileSystemResource.getFile().isDirectory()) {
            hasExactlyOneInputFileToProcess = true;
        }
        return hasExactlyOneInputFileToProcess;
    }

    @Override
    protected final List acquireData(DataProcessExecutionContext context) throws Exception {
        FileSystemResource fileSystemResource = new FileSystemResource(this.inputFileLocation);
        List data = Collections.EMPTY_LIST;
        if (fileSystemResource.exists()) {
            if (context instanceof DataFileProcessExecutionContext) {
                ((DataFileProcessExecutionContext)context).setCurrentFile(fileSystemResource.getFile());
            }
            data = this.doAcquireData(context, new FileSystemResource(this.inputFileLocation));
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("The inputFile [" + this.inputFileLocation + "] for " + this.getProcessName() + " does not exist"));
        }
        return data;
    }

    protected List doAcquireData(DataProcessExecutionContext context, FileSystemResource fileSystemResource) throws Exception {
        return (List)this.inputFileReader.build(new Object[]{context, fileSystemResource});
    }

    protected final void logParsedFile(DataFileProcessExecutionContext context) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("File Parsing completed for inputFile [" + context.getCurrentFile() + "]"));
        }
    }

    public String getInputFileLocation() {
        return this.inputFileLocation;
    }

    public void setInputFileLocation(String inputFileLocation) {
        this.inputFileLocation = inputFileLocation;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.inputFileLocation, (String)"A file location is needed to acquire data");
        Validate.notNull((Object)this.inputFileReader, (String)"A Builder is needed to parse the data");
        if (this.inputFileLocation.indexOf("*") != -1) {
            int lastIndex = this.inputFileLocation.lastIndexOf("/");
            if (lastIndex == -1) {
                lastIndex = this.inputFileLocation.lastIndexOf("\\");
            }
            this.inputFileFilter = new WildcardFileFilter(this.inputFileLocation.substring(lastIndex + 1), this.caseInsensitive);
            this.inputFileLocation = this.inputFileLocation.substring(0, lastIndex);
        }
    }

    public Builder getInputFileReader() {
        return this.inputFileReader;
    }

    public void setInputFileReader(Builder inputFileReader) {
        this.inputFileReader = inputFileReader;
    }

    public boolean isHandleEachFileSeparately() {
        return this.handleEachFileSeparately;
    }

    public void setHandleEachFileSeparately(boolean handleEachFileSeparately) {
        this.handleEachFileSeparately = handleEachFileSeparately;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    protected boolean shouldUpdateJobResult(DataProcessExecutionContext context) {
        return true;
    }
}

