/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.batchprocess.AbstractDataFileListenerProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.List;

public abstract class AbstractDataFileIncrementalProcess
extends AbstractDataFileListenerProcess {
    private int incrementSize = 25;

    @Override
    public boolean acceptData(DataFileProcessExecutionContext context, String nextRowRawData, List beans) {
        return beans.size() == this.incrementSize;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (this.incrementSize <= 0) {
            throw new InvalidConfigurationException("Invalid incrementSize.  Must be positive number");
        }
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public void setIncrementSize(int incrementSize) {
        this.incrementSize = incrementSize;
    }

    @Override
    protected boolean shouldUpdateJobResult(DataFileProcessExecutionContext context) {
        return context.getProcessStatistics().isTotalNumberMod(this.incrementSize);
    }
}

