/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.batchprocess;

import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.scheduling.SpawnedScheduledProcess;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.service.support.SpawnedThreadInvoker;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class AbstractConcurrentProcess
extends AbstractScheduledProcess {
    private LoginManager loginManager;
    private Set processes;

    @Override
    protected void executeProcess(ScheduledProcessInvocationContext invContext) throws Exception {
        Iterator itr = this.getProcesses().iterator();
        ScheduledProcess targetProcess = null;
        while (itr.hasNext()) {
            targetProcess = (ScheduledProcess)itr.next();
            SpawnedScheduledProcess spawnedProcess = new SpawnedScheduledProcess();
            spawnedProcess.setContext(invContext);
            spawnedProcess.setProcess(targetProcess);
            spawnedProcess.setAuditInfo(targetProcess.getAuditInfo(invContext));
            spawnedProcess.setLoginManager(this.loginManager);
            SpawnedThreadInvoker invoker = new SpawnedThreadInvoker(spawnedProcess, false);
            invoker.execute();
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        Iterator itr = this.getProcesses().iterator();
        while (itr.hasNext()) {
            ((ScheduledProcess)itr.next()).interrupt();
        }
    }

    public Set getProcesses() {
        return this.processes;
    }

    public void setProcesses(Set processes) {
        this.processes = processes;
    }

    @Override
    public void afterPropertiesSet() {
        Validate.notNull((Object)this.loginManager, (String)"A LoginManager is needed for the spawned threads");
        if (this.processes == null || this.processes.isEmpty()) {
            throw new InvalidConfigurationException("Must configure at least one ScheduledProcess to launch");
        }
    }

    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }
}

