/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util.builder.decorator;

import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.util.builder.Validator;
import gov.va.med.fw.util.builder.ValidatorException;
import gov.va.med.fw.util.builder.decorator.AbstractBuilderDecorator;

public class PostValidatingBuilder
extends AbstractBuilderDecorator {
    private static final long serialVersionUID = -3727312062752313154L;
    private Validator postValidator;

    public static Builder decorate(Builder builder, Validator postValidator) {
        return new PostValidatingBuilder(builder, postValidator);
    }

    protected PostValidatingBuilder(Builder builder, Validator postValidator) {
        super(builder);
        if (postValidator == null) {
            throw new IllegalArgumentException("postValidator cannot be null");
        }
        this.postValidator = postValidator;
    }

    @Override
    public Object build(Object input) throws BuilderException {
        try {
            Object result = super.getBuilder().build(input);
            if (result != null) {
                this.postValidator.validate(result);
            }
            return result;
        }
        catch (ValidatorException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }
}

