/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util.builder;

import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.ModelPropertiesApplicationType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.EqualsBuilder;

public class AbstractEntityEqualsBuilder
extends EqualsBuilder {
    private String modelPropertiesApplication;
    private String notEqualsProperty = null;
    private String notEqualsLhs = null;
    private String notEqualsRhs = null;

    public AbstractEntityEqualsBuilder(String modelPropertiesApplication) {
        this.modelPropertiesApplication = modelPropertiesApplication;
    }

    public AbstractEntityEqualsBuilder append(OrderedMap lhsMap, OrderedMap rhsMap) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhsMap == rhsMap) {
            return this;
        }
        if (lhsMap == null || rhsMap == null) {
            this.setNotEqualsNullMap((Map)lhsMap, (Map)rhsMap);
            return this;
        }
        if (lhsMap.size() != rhsMap.size()) {
            this.setNotEqualsDifferentSizedMaps((Map)lhsMap, (Map)rhsMap);
            return this;
        }
        for (String propertyName : lhsMap.keySet()) {
            this.append(lhsMap.get((Object)propertyName), rhsMap.get((Object)propertyName), propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(Object lhs, Object rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        Class<?> lhsClass = lhs.getClass();
        if (!lhsClass.isArray()) {
            if (Collection.class.isAssignableFrom(lhsClass)) {
                Collection lhsCollection = (Collection)lhs;
                Collection rhsCollection = (Collection)rhs;
                this.processCollection(lhsCollection, rhsCollection, propertyName);
            } else if (Map.class.isAssignableFrom(lhsClass)) {
                Map lhsMap = (Map)lhs;
                Map rhsMap = (Map)rhs;
                this.processMap(lhsMap, rhsMap, propertyName);
            } else {
                boolean isEqual = false;
                if (AbstractEntity.class.isAssignableFrom(lhsClass)) {
                    AbstractEntity lhsEntity = (AbstractEntity)lhs;
                    isEqual = ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName().equals(this.modelPropertiesApplication) ? lhsEntity.matchesDomainConcept(rhs) : (ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName().equals(this.modelPropertiesApplication) ? lhsEntity.matchesDomainValues(rhs) : lhsEntity.equals(rhs));
                } else if (Date.class.isAssignableFrom(lhsClass)) {
                    Date lhsDate = (Date)lhs;
                    Date rhsDate = (Date)rhs;
                    isEqual = lhsDate.getTime() == rhsDate.getTime();
                } else {
                    isEqual = lhs.equals(rhs);
                }
                if (!isEqual) {
                    this.setNotEquals(lhs, rhs, propertyName);
                }
            }
        } else if (lhs.getClass() != rhs.getClass()) {
            this.setNotEquals(lhs, rhs, propertyName);
        } else if (lhs instanceof long[]) {
            this.append((long[])lhs, (long[])rhs, propertyName);
        } else if (lhs instanceof int[]) {
            this.append((int[])lhs, (int[])rhs, propertyName);
        } else if (lhs instanceof short[]) {
            this.append((short[])lhs, (short[])rhs, propertyName);
        } else if (lhs instanceof char[]) {
            this.append((char[])lhs, (char[])rhs, propertyName);
        } else if (lhs instanceof byte[]) {
            this.append((byte[])lhs, (byte[])rhs, propertyName);
        } else if (lhs instanceof double[]) {
            this.append((double[])lhs, (double[])rhs, propertyName);
        } else if (lhs instanceof float[]) {
            this.append((float[])lhs, (float[])rhs, propertyName);
        } else if (lhs instanceof boolean[]) {
            this.append((boolean[])lhs, (boolean[])rhs, propertyName);
        } else {
            List<Object> lhsCollection = Arrays.asList((Object[])lhs);
            List<Object> rhsCollection = Arrays.asList((Object[])rhs);
            this.processCollection(lhsCollection, rhsCollection, propertyName);
        }
        return this;
    }

    protected void processCollection(Collection lhsCollection, Collection rhsCollection, String propertyName) {
        boolean isEqual = false;
        isEqual = ModelPropertiesApplicationType.MATCH_DOMAIN_CONCEPT.getName().equals(this.modelPropertiesApplication) ? AbstractEntity.matchesDomainConcept(lhsCollection, rhsCollection) : (ModelPropertiesApplicationType.MATCH_DOMAIN_VALUES.getName().equals(this.modelPropertiesApplication) ? AbstractEntity.matchesDomainValues(lhsCollection, rhsCollection) : AbstractEntity.equals(lhsCollection, rhsCollection));
        if (!isEqual) {
            this.setNotEquals(lhsCollection, rhsCollection, propertyName);
        }
    }

    protected void processMap(Map lhsMap, Map rhsMap, String propertyName) {
        boolean isEqual = AbstractEntity.isModelPropertiesEqual(lhsMap, rhsMap, this.modelPropertiesApplication);
        if (!isEqual) {
            this.setNotEquals(lhsMap, rhsMap, propertyName);
        }
    }

    public AbstractEntityEqualsBuilder append(long[] lhs, long[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(int[] lhs, int[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(short[] lhs, short[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(char[] lhs, char[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(byte[] lhs, byte[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(double[] lhs, double[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(float[] lhs, float[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(boolean[] lhs, boolean[] rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null || rhs == null) {
            this.setNotEquals(lhs, rhs, propertyName);
            return this;
        }
        if (lhs.length != rhs.length) {
            this.setNotEqualsDifferentSizedArrays(lhs.length, rhs.length);
            return this;
        }
        for (int i = 0; i < lhs.length && this.isEquals(); ++i) {
            this.append(lhs[i], rhs[i], propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(long lhs, long rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs != rhs) {
            this.setNotEquals(String.valueOf(lhs), String.valueOf(rhs), propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(int lhs, int rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs != rhs) {
            this.setNotEquals(String.valueOf(lhs), String.valueOf(rhs), propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(short lhs, short rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs != rhs) {
            this.setNotEquals(String.valueOf(lhs), String.valueOf(rhs), propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(char lhs, char rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs != rhs) {
            this.setNotEquals(String.valueOf(lhs), String.valueOf(rhs), propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(byte lhs, byte rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs != rhs) {
            this.setNotEquals(String.valueOf(lhs), String.valueOf(rhs), propertyName);
        }
        return this;
    }

    public AbstractEntityEqualsBuilder append(double lhs, double rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        return this.append(Double.doubleToLongBits(lhs), Double.doubleToLongBits(rhs), propertyName);
    }

    public AbstractEntityEqualsBuilder append(float lhs, float rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        return this.append(Float.floatToIntBits(lhs), Float.floatToIntBits(rhs), propertyName);
    }

    public AbstractEntityEqualsBuilder append(boolean lhs, boolean rhs, String propertyName) {
        if (!this.isEquals()) {
            return this;
        }
        if (lhs != rhs) {
            this.setNotEquals(String.valueOf(lhs), String.valueOf(rhs), propertyName);
        }
        return this;
    }

    public String getModelPropertiesApplication() {
        return this.modelPropertiesApplication;
    }

    protected void setNotEqualsNullMap(Map lhsMap, Map rhsMap) {
        this.setNotEquals(lhsMap, rhsMap, lhsMap == null ? "Left hand side Map" : "Right hand side Map is null");
    }

    protected void setNotEqualsDifferentSizedMaps(Map lhsMap, Map rhsMap) {
        this.setNotEquals(String.valueOf(lhsMap.size()), String.valueOf(rhsMap.size()), "Maps contain different sizes");
    }

    protected void setNotEqualsDifferentSizedArrays(int lhsSize, int rhsSize) {
        this.setNotEquals(String.valueOf(lhsSize), String.valueOf(rhsSize), "Arrays contain different sizes");
    }

    protected void setNotEquals(Object lhs, Object rhs, String notEqualsProperty) {
        if (this.isEquals()) {
            this.setEquals(false);
            this.setNotEqualsProperty(notEqualsProperty);
            this.setNotEqualsLhs(this.getObjectAsString(lhs));
            this.setNotEqualsRhs(this.getObjectAsString(rhs));
        }
    }

    protected String getObjectAsString(Object o) {
        if (o == null) {
            return "null";
        }
        Class<?> oClass = o.getClass();
        if (String.class.isAssignableFrom(oClass)) {
            return (String)o;
        }
        if (AbstractLookup.class.isAssignableFrom(oClass)) {
            return ((AbstractLookup)o).getCode();
        }
        if (oClass.isArray() || Collection.class.isAssignableFrom(oClass) || Map.class.isAssignableFrom(oClass) || AbstractEntity.class.isAssignableFrom(oClass)) {
            return oClass.getName();
        }
        return o.toString();
    }

    protected void setNotEqualsProperty(String notEqualsProperty) {
        this.notEqualsProperty = notEqualsProperty;
    }

    public String getNotEqualsProperty() {
        return this.notEqualsProperty;
    }

    public String getNotEqualsLhs() {
        return this.notEqualsLhs;
    }

    protected void setNotEqualsLhs(String notEqualsLhs) {
        this.notEqualsLhs = notEqualsLhs;
    }

    public String getNotEqualsRhs() {
        return this.notEqualsRhs;
    }

    protected void setNotEqualsRhs(String notEqualsRhs) {
        this.notEqualsRhs = notEqualsRhs;
    }
}

