/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.fw.util;

import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaskQueue {
    private Log log = LogFactory.getLog(TaskQueue.class);
    private LinkedList list = new LinkedList();
    private long defaultTimeout = 10000L;

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized void add(Object object) {
        this.list.add(object);
        this.notify();
    }

    public synchronized Object remove() {
        Object answer;
        while ((answer = this.removeNoWait()) == null) {
            try {
                this.wait(this.defaultTimeout);
                continue;
            }
            catch (InterruptedException e) {
                this.log.error((Object)("Thread was interrupted: " + e), (Throwable)e);
                continue;
            }
            break;
        }
        return answer;
    }

    public void clearQueue() {
        this.list.clear();
    }

    public synchronized Object remove(long timeout) {
        Object answer = this.removeNoWait();
        if (answer == null) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                this.log.error((Object)("Thread was interrupted: " + e), (Throwable)e);
            }
            answer = this.removeNoWait();
        }
        return answer;
    }

    public synchronized Object removeNoWait() {
        if (!this.list.isEmpty()) {
            return this.list.removeFirst();
        }
        return null;
    }
}

